/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ConstNumber
implements CookIngredients {
    float n;
    public static final MapCodec<ConstNumber> CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Codec.FLOAT.fieldOf("num").forGetter(o -> Float.valueOf(o.n))).apply((Applicative)t, ConstNumber::new));

    public ConstNumber(JsonElement num) {
        this.n = num.isJsonPrimitive() ? num.getAsFloat() : num.getAsJsonObject().get("num").getAsFloat();
    }

    public ConstNumber(float n) {
        this.n = n;
    }

    @Override
    public Float apply(IPendingContext t) {
        return Float.valueOf(this.n);
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return false;
    }

    @Override
    public Stream<CookIngredients> getItemRelated() {
        return Stream.empty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.n);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstNumber)) {
            return false;
        }
        ConstNumber other = (ConstNumber)obj;
        return Float.floatToIntBits(this.n) == Float.floatToIntBits(other.n);
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.empty();
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return String.valueOf(this.n);
    }

    @Override
    public Stream<ItemStack> getStacks() {
        return Stream.of(new ItemStack[0]);
    }
}

