/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.numbers.Numbers;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;

public abstract class NumberedStewCondition
implements IngredientCondition {
    protected CookIngredients number;

    public static <T extends NumberedStewCondition> MapCodec<T> createCodec(Function<CookIngredients, T> factory) {
        return RecordCodecBuilder.mapCodec(t -> t.group((App)Numbers.CODEC.fieldOf("number").forGetter(o -> o.number)).apply((Applicative)t, factory));
    }

    public NumberedStewCondition(CookIngredients number) {
        this.number = number;
    }

    @Override
    public boolean test(IPendingContext t) {
        return this.test(t, t.compute(this.number));
    }

    public abstract boolean test(IPendingContext var1, float var2);

    @Override
    public Stream<CookIngredients> getAllNumbers() {
        return Stream.of(this.number);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NumberedStewCondition)) {
            return false;
        }
        NumberedStewCondition other = (NumberedStewCondition)obj;
        return !(this.number == null ? other.number != null : !this.number.equals(other.number));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return this.number.getTags();
    }
}

