/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.data.recipes.conditions.NumberedStewCondition;
import com.teammoeg.caupona.data.recipes.numbers.Numbers;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;

public class MainlyOfType
extends NumberedStewCondition {
    private final ResourceLocation type;
    public static final MapCodec<MainlyOfType> CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Numbers.CODEC.fieldOf("number").forGetter(o -> o.number), (App)ResourceLocation.CODEC.fieldOf("tag").forGetter(o -> o.type)).apply((Applicative)t, MainlyOfType::new));

    public MainlyOfType(CookIngredients obj, ResourceLocation type) {
        super(obj);
        this.type = type;
    }

    @Override
    public boolean test(IPendingContext t, float n) {
        float thistype = t.getOfType(this.type);
        if (n < thistype / 3.0f) {
            return false;
        }
        return FloatemTagStack.calculateTypes(t.getItems().stream().filter(e -> e.getTags().contains(this.type)).filter(e -> !this.number.fits((FloatemTagStack)e))).values().stream().allMatch(e -> e.floatValue() < n);
    }

    @Override
    public String getType() {
        return "mainlyOf";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MainlyOfType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MainlyOfType other = (MainlyOfType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.concat(super.getTags(), Stream.of(this.type));
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation("recipe.caupona.cond.mainlyof", this.number.getTranslation(p), p.getTranslation("tag." + this.type.toString().replaceAll("[:/]", "."), new Object[0]));
    }
}

