/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.conditions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.teammoeg.caupona.data.DataDeserializerRegistry;
import com.teammoeg.caupona.data.Deserializer;
import com.teammoeg.caupona.data.InvalidRecipeException;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.conditions.Halfs;
import com.teammoeg.caupona.data.recipes.conditions.Mainly;
import com.teammoeg.caupona.data.recipes.conditions.MainlyOfType;
import com.teammoeg.caupona.data.recipes.conditions.Must;
import com.teammoeg.caupona.data.recipes.conditions.Only;
import com.teammoeg.caupona.util.SerializeUtil;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class Conditions {
    private static DataDeserializerRegistry<IngredientCondition> numbers = new DataDeserializerRegistry();
    public static final Codec<IngredientCondition> CODEC = numbers.createCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientCondition> STREAM_CODEC = numbers.createStreamCodec();

    public static void register(String name, Deserializer<IngredientCondition> des) {
        numbers.register(name, des);
    }

    public static <R extends IngredientCondition> void register(String name, Class<R> cls, MapCodec<R> rjson) {
        numbers.register(name, cls, rjson, SerializeUtil.toStreamCodec(rjson));
    }

    public static void checkConditions(Collection<IngredientCondition> allow) {
        if (allow == null) {
            return;
        }
        boolean foundMajor = false;
        HashSet conts = new HashSet();
        for (IngredientCondition c : allow) {
            if (c.isMajor()) {
                if (foundMajor) {
                    throw new InvalidRecipeException("There must be less than one major condition. (Current: " + c.getType() + ")");
                }
                foundMajor = true;
                continue;
            }
            if (!c.isExclusive()) continue;
            if (conts.contains(c.getClass())) {
                throw new InvalidRecipeException("There must be less than one " + c.getType() + " condition.");
            }
            conts.add(c.getClass());
        }
    }

    public static void clearCache() {
        numbers.clearCache();
    }

    static {
        Conditions.register("half", Halfs.class, Halfs.CODEC);
        Conditions.register("mainly", Mainly.class, Mainly.CODEC);
        Conditions.register("contains", Must.class, Must.CODEC);
        Conditions.register("mainlyOf", MainlyOfType.class, MainlyOfType.CODEC);
        Conditions.register("only", Only.class, Only.CODEC);
    }
}

