/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.baseconditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.StewBaseCondition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class FluidTag
implements StewBaseCondition {
    TagKey<Fluid> f;
    public static final MapCodec<FluidTag> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)ResourceLocation.CODEC.fieldOf("tag").forGetter(t -> t.f.location())).apply((Applicative)c, FluidTag::new));

    public FluidTag(ResourceLocation tag) {
        this.f = FluidTags.create((ResourceLocation)tag);
    }

    public FluidTag(TagKey<Fluid> tag) {
        this.f = tag;
    }

    @Override
    public Integer apply(Fluid t, Fluid u) {
        return this.test(u) ? 2 : (this.test(t) ? 1 : 0);
    }

    @Override
    public boolean test(Fluid t) {
        return BuiltInRegistries.FLUID.wrapAsHolder((Object)t).is(this.f);
    }

    public FluidTag(FriendlyByteBuf buffer) {
        this.f = FluidTags.create((ResourceLocation)buffer.readResourceLocation());
    }

    @Override
    public String getType() {
        return "tag";
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation("tag." + this.f.location().toLanguageKey().replaceAll("/", "."), new Object[0]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FluidTag other = (FluidTag)obj;
        return !(this.f == null ? other.f != null : !this.f.equals(other.f));
    }
}

