/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.recipes.BoilingRecipe;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IConditionalRecipe;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.StewBaseCondition;
import com.teammoeg.caupona.data.recipes.StewPendingContext;
import com.teammoeg.caupona.data.recipes.baseconditions.BaseConditions;
import com.teammoeg.caupona.data.recipes.conditions.Conditions;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StewCookingRecipe
extends IDataRecipe
implements IConditionalRecipe {
    public static Set<CookIngredients> cookables;
    public static Set<Fluid> allOutput;
    public static List<RecipeHolder<StewCookingRecipe>> sorted;
    public static DeferredHolder<RecipeType<?>, RecipeType<Recipe<?>>> TYPE;
    public static DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SERIALIZER;
    List<IngredientCondition> allow;
    List<IngredientCondition> deny;
    int priority = 0;
    public int time;
    float density;
    List<StewBaseCondition> base;
    public Fluid output;
    public boolean removeNBT = false;
    public static final MapCodec<StewCookingRecipe> CODEC;

    public StewCookingRecipe(List<IngredientCondition> allow, List<IngredientCondition> deny, int priority, int time, float density, List<StewBaseCondition> base, Fluid output, boolean removeNBT) {
        this.allow = allow;
        this.deny = deny;
        this.priority = priority;
        this.time = time;
        this.density = density;
        this.base = base;
        this.output = output;
        this.removeNBT = removeNBT;
    }

    public static boolean isCookable(ItemStack stack) {
        FloatemTagStack s = new FloatemTagStack(stack);
        return stack.is(CPTags.Items.COOKABLE) || cookables.stream().anyMatch(e -> e.fits(s));
    }

    public static boolean isBoilable(FluidStack f) {
        Fluid fd = f.getFluid();
        return fd instanceof SoupFluid || f.getFluid().is(CPTags.Fluids.BOILABLE) || BoilingRecipe.allBoilables.contains(f.getFluid());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TYPE.get();
    }

    public StewCookingRecipe(Optional<List<IngredientCondition>> allow, Optional<List<IngredientCondition>> deny, int priority, int time, float density, Optional<List<StewBaseCondition>> base, Fluid output, boolean removeNBT) {
        this.allow = allow.orElseGet(ImmutableList::of);
        this.deny = deny.orElseGet(ImmutableList::of);
        this.priority = priority;
        this.time = time;
        this.density = density;
        this.base = base.orElseGet(ImmutableList::of);
        this.output = output;
        this.removeNBT = removeNBT;
    }

    public int matches(StewPendingContext ctx) {
        if (ctx.getTotalItems() < this.density) {
            return 0;
        }
        int matchtype = 0;
        if (this.base != null && !this.base.isEmpty()) {
            StewBaseCondition e;
            Iterator<StewBaseCondition> iterator = this.base.iterator();
            while (iterator.hasNext() && (matchtype = ctx.compute(e = iterator.next())) == 0) {
            }
            if (matchtype == 0) {
                return 0;
            }
        }
        if (matchtype == 0) {
            matchtype = 1;
        }
        if (!this.allow.isEmpty()) {
            if (!this.allow.stream().allMatch(ctx::compute)) {
                return 0;
            }
        }
        if (!this.deny.isEmpty()) {
            if (this.deny.stream().anyMatch(ctx::compute)) {
                return 0;
            }
        }
        return matchtype;
    }

    public Stream<CookIngredients> getAllNumbers() {
        return Stream.concat(this.allow.stream().flatMap(IngredientCondition::getAllNumbers), this.deny.stream().flatMap(IngredientCondition::getAllNumbers));
    }

    public Stream<ResourceLocation> getTags() {
        return Stream.concat(this.allow.stream().flatMap(IngredientCondition::getTags), this.deny.stream().flatMap(IngredientCondition::getTags));
    }

    public int getPriority() {
        return this.priority;
    }

    public List<StewBaseCondition> getBase() {
        return this.base;
    }

    @Override
    public List<IngredientCondition> getAllow() {
        return this.allow;
    }

    @Override
    public List<IngredientCondition> getDeny() {
        return this.deny;
    }

    public float getDensity() {
        return this.density;
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Codec.list(Conditions.CODEC).optionalFieldOf("allow").forGetter(o -> Optional.ofNullable(o.allow)), (App)Codec.list(Conditions.CODEC).optionalFieldOf("deny").forGetter(o -> Optional.ofNullable(o.deny)), (App)Codec.INT.fieldOf("priority").forGetter(o -> o.priority), (App)Codec.INT.fieldOf("time").forGetter(o -> o.time), (App)Codec.FLOAT.fieldOf("density").forGetter(o -> Float.valueOf(o.density)), (App)Codec.list(BaseConditions.CODEC).optionalFieldOf("base").forGetter(o -> Optional.ofNullable(o.base)), (App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("output").forGetter(o -> o.output), (App)Codec.BOOL.fieldOf("removeNBT").forGetter(o -> o.removeNBT)).apply((Applicative)t, StewCookingRecipe::new));
    }
}

