/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.IDataRecipe;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SpiceRecipe
extends IDataRecipe {
    public static List<SpiceRecipe> recipes;
    public static DeferredHolder<RecipeType<?>, RecipeType<Recipe<?>>> TYPE;
    public static DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SERIALIZER;
    public Ingredient spice;
    public MobEffectInstance effect;
    public boolean canReactLead = false;
    public static final MapCodec<SpiceRecipe> CODEC;

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TYPE.get();
    }

    public SpiceRecipe(Ingredient spice, MobEffectInstance effect) {
        this.spice = spice;
        this.effect = effect;
    }

    public SpiceRecipe(Ingredient spice, MobEffectInstance effect, boolean canReactLead) {
        this.spice = spice;
        this.effect = effect;
        this.canReactLead = canReactLead;
    }

    public static int getMaxUse(ItemStack spice) {
        return spice.getMaxDamage() - spice.getDamageValue();
    }

    public static ItemStack handle(ItemStack spice, int cnt) {
        int cdmg = spice.getDamageValue();
        if ((cdmg += cnt) >= spice.getMaxDamage()) {
            return spice.getCraftingRemainingItem();
        }
        spice.setDamageValue(cdmg);
        return spice;
    }

    public static SpiceRecipe find(ItemStack spice) {
        return recipes.stream().filter(e -> e.spice.test(spice)).findFirst().orElse(null);
    }

    public static boolean isValid(ItemStack spice) {
        return recipes.stream().anyMatch(e -> e.spice.test(spice));
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("spice").forGetter(o -> o.spice), (App)MobEffectInstance.CODEC.fieldOf("effect").forGetter(o -> o.effect), (App)Codec.BOOL.fieldOf("reacts_lead").forGetter(o -> o.canReactLead)).apply((Applicative)t, SpiceRecipe::new));
    }
}

