/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IConditionalRecipe;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.PanPendingContext;
import com.teammoeg.caupona.data.recipes.conditions.Conditions;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SauteedRecipe
extends IDataRecipe
implements IConditionalRecipe {
    public static Set<CookIngredients> cookables;
    public static List<RecipeHolder<SauteedRecipe>> sorted;
    public static DeferredHolder<RecipeType<?>, RecipeType<Recipe<?>>> TYPE;
    public static DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SERIALIZER;
    List<IngredientCondition> allow;
    List<IngredientCondition> deny;
    int priority = 0;
    public int time;
    public Item output;
    public boolean removeNBT = false;
    public float count = 2.0f;
    public static final MapCodec<SauteedRecipe> CODEC;

    public SauteedRecipe(List<IngredientCondition> allow, List<IngredientCondition> deny, int priority, int time, Item output, boolean removeNBT, float count) {
        this.allow = allow;
        this.deny = deny;
        this.priority = priority;
        this.time = time;
        this.output = output;
        this.removeNBT = removeNBT;
        this.count = count;
    }

    public static boolean isCookable(ItemStack stack) {
        FloatemTagStack s = new FloatemTagStack(stack);
        return stack.is(CPTags.Items.COOKABLE) || cookables.stream().anyMatch(e -> e.fits(s));
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TYPE.get();
    }

    public SauteedRecipe(Optional<List<IngredientCondition>> allow, Optional<List<IngredientCondition>> deny, int priority, int time, Item output, boolean removeNBT, float count) {
        this.allow = allow.orElse(null);
        this.deny = deny.orElse(null);
        this.priority = priority;
        this.time = time;
        this.output = output;
        this.removeNBT = removeNBT;
        this.count = count;
    }

    public boolean matches(PanPendingContext ctx) {
        if (this.allow != null) {
            if (!this.allow.stream().allMatch(ctx::compute)) {
                return false;
            }
        }
        if (this.deny != null) {
            if (this.deny.stream().anyMatch(ctx::compute)) {
                return false;
            }
        }
        return true;
    }

    public Stream<CookIngredients> getAllNumbers() {
        return Stream.concat(this.allow == null ? Stream.empty() : this.allow.stream().flatMap(IngredientCondition::getAllNumbers), this.deny == null ? Stream.empty() : this.deny.stream().flatMap(IngredientCondition::getAllNumbers));
    }

    public Stream<ResourceLocation> getTags() {
        return Stream.concat(this.allow == null ? Stream.empty() : this.allow.stream().flatMap(IngredientCondition::getTags), this.deny == null ? Stream.empty() : this.deny.stream().flatMap(IngredientCondition::getTags));
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<IngredientCondition> getAllow() {
        return this.allow;
    }

    @Override
    public List<IngredientCondition> getDeny() {
        return this.deny;
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Codec.list(Conditions.CODEC).optionalFieldOf("allow").forGetter(o -> Optional.ofNullable(o.allow)), (App)Codec.list(Conditions.CODEC).optionalFieldOf("deny").forGetter(o -> Optional.ofNullable(o.deny)), (App)Codec.INT.fieldOf("priority").forGetter(o -> o.priority), (App)Codec.INT.fieldOf("time").forGetter(o -> o.time), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("output").forGetter(o -> o.output), (App)Codec.BOOL.fieldOf("removeNBT").forGetter(o -> o.removeNBT), (App)Codec.FLOAT.fieldOf("ingredientPerDish").forGetter(o -> Float.valueOf(o.count))).apply((Applicative)t, SauteedRecipe::new));
    }
}

