/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.recipes.CountingTags;
import com.teammoeg.caupona.util.Utils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FoodValueRecipe
extends IDataRecipe {
    public static Map<Item, FoodValueRecipe> recipes;
    public static DeferredHolder<RecipeType<?>, RecipeType<Recipe<?>>> TYPE;
    public static DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SERIALIZER;
    public static Set<FoodValueRecipe> recipeset;
    public int heal;
    public float sat;
    public List<FoodProperties.PossibleEffect> effects;
    public final Map<Item, Integer> processtimes;
    private ItemStack repersent;
    public transient Set<ResourceLocation> tags;
    public static final MapCodec<FoodValueRecipe> CODEC;

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TYPE.get();
    }

    public FoodValueRecipe(int heal, float sat, Optional<List<FoodProperties.PossibleEffect>> effects, List<Pair<Item, Integer>> processtimes, Ingredient repersent) {
        this.heal = heal;
        this.sat = sat;
        this.effects = effects.orElse(null);
        this.processtimes = new HashMap<Item, Integer>();
        for (Pair<Item, Integer> i : processtimes) {
            this.processtimes.put((Item)i.getFirst(), (Integer)i.getSecond());
        }
        if (!repersent.isEmpty()) {
            this.repersent = repersent.getItems()[0];
        }
    }

    public List<Pair<Item, Integer>> getProcessTime() {
        return this.processtimes.entrySet().stream().map(t -> Pair.of((Object)((Item)t.getKey()), (Object)((Integer)t.getValue()))).toList();
    }

    public FoodValueRecipe(int heal, float sat, ItemStack rps, Item ... types) {
        this.heal = heal;
        this.sat = sat;
        this.processtimes = new LinkedHashMap<Item, Integer>();
        this.repersent = rps;
        for (Item i : types) {
            this.processtimes.put(i, 0);
        }
    }

    public void clearCache() {
        this.tags = null;
    }

    public Set<ResourceLocation> getTags() {
        if (this.tags == null) {
            this.tags = this.processtimes.keySet().stream().flatMap(i -> BuiltInRegistries.ITEM.getHolder(BuiltInRegistries.ITEM.getId(i)).map(Holder::tags).orElseGet(Stream::empty).map(TagKey::location)).filter(CountingTags.tags::contains).collect(Collectors.toSet());
        }
        return this.tags;
    }

    public ItemStack getRepersent() {
        return this.repersent;
    }

    public void setRepersent(ItemStack repersent) {
        this.repersent = repersent != null ? repersent.copy() : null;
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Codec.INT.fieldOf("heal").forGetter(o -> o.heal), (App)Codec.FLOAT.fieldOf("sat").forGetter(o -> Float.valueOf(o.sat)), (App)Codec.optionalField((String)"effects", (Codec)Codec.list((Codec)FoodProperties.PossibleEffect.CODEC), (boolean)false).forGetter(o -> Optional.ofNullable(o.effects)), (App)Codec.list(Utils.pairCodec("item", BuiltInRegistries.ITEM.byNameCodec(), "time", Codec.INT)).fieldOf("items").forGetter(o -> o.getProcessTime()), (App)Ingredient.CODEC.fieldOf("item").forGetter(o -> Ingredient.of((ItemStack[])new ItemStack[]{o.repersent}))).apply((Applicative)t, FoodValueRecipe::new));
    }
}

