/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.util.ChancedEffect;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FluidFoodValueRecipe
extends IDataRecipe {
    public static Map<ResourceLocation, RecipeHolder<FluidFoodValueRecipe>> recipes;
    public static DeferredHolder<RecipeType<?>, RecipeType<Recipe<?>>> TYPE;
    public static DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SERIALIZER;
    public int heal;
    public float sat;
    public List<ChancedEffect> effects;
    private Ingredient repersent;
    public int parts;
    public ResourceLocation f;
    public static final MapCodec<FluidFoodValueRecipe> CODEC;

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TYPE.get();
    }

    public FluidFoodValueRecipe(int heal, float sat, ItemStack repersent, int parts, Fluid f) {
        this.heal = heal;
        this.sat = sat;
        this.repersent = Ingredient.of((ItemStack[])new ItemStack[]{repersent});
        this.parts = parts;
        this.f = Utils.getRegistryName(f);
    }

    public FluidFoodValueRecipe(int heal, float sat, Optional<List<ChancedEffect>> effects, Optional<Ingredient> repersent, int parts, ResourceLocation f) {
        this.heal = heal;
        this.sat = sat;
        this.effects = effects.orElse(null);
        if (!repersent.isEmpty()) {
            this.repersent = repersent.orElse(Ingredient.EMPTY);
        }
        this.parts = parts;
        this.f = f;
    }

    public FluidFoodValueRecipe(int heal, float sat, ItemStack repersent, int parts, ResourceLocation f) {
        this.heal = heal;
        this.sat = sat;
        if (repersent != null) {
            this.repersent = Ingredient.of((ItemStack[])new ItemStack[]{repersent});
        }
        this.parts = parts;
        this.f = f;
    }

    public ItemStack getRepersent() {
        return this.repersent.getItems()[0];
    }

    public void setRepersent(ItemStack repersent) {
        this.repersent = repersent != null ? Ingredient.of((ItemStack[])new ItemStack[]{repersent}) : Ingredient.EMPTY;
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Codec.INT.fieldOf("heal").forGetter(o -> o.heal), (App)Codec.FLOAT.fieldOf("sat").forGetter(o -> Float.valueOf(o.sat)), (App)Codec.list(ChancedEffect.CODEC).optionalFieldOf("effects").forGetter(o -> Optional.ofNullable(o.effects)), (App)Ingredient.CODEC.optionalFieldOf("item").forGetter(o -> o.repersent == null ? Optional.empty() : Optional.of(o.repersent)), (App)Codec.INT.fieldOf("parts").forGetter(o -> o.parts), (App)ResourceLocation.CODEC.fieldOf("fluid").forGetter(o -> o.f)).apply((Applicative)t, FluidFoodValueRecipe::new));
    }
}

