/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.registries.DeferredHolder;

public class DoliumRecipe
extends IDataRecipe {
    public static List<RecipeHolder<DoliumRecipe>> recipes;
    public static DeferredHolder<RecipeType<?>, RecipeType<Recipe<?>>> TYPE;
    public static DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SERIALIZER;
    public List<Pair<Ingredient, Integer>> items;
    public Ingredient extra;
    public Fluid base;
    public Fluid fluid = Fluids.EMPTY;
    public int amount = 250;
    public float density = 0.0f;
    public boolean keepInfo = false;
    public ItemStack output;
    public static final MapCodec<DoliumRecipe> CODEC;

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TYPE.get();
    }

    public DoliumRecipe(Fluid base, Fluid fluid, int amount, float density, boolean keep, ItemStack out, List<Pair<Ingredient, Integer>> items) {
        this(base, fluid, amount, density, keep, out, items, null);
    }

    public DoliumRecipe(List<Pair<Ingredient, Integer>> items, Optional<Ingredient> extra, Optional<Fluid> base, Fluid fluid, int amount, float density, boolean keepInfo, Ingredient output) {
        this.items = items;
        this.extra = extra.orElse(null);
        this.base = base.orElse(null);
        this.fluid = fluid;
        this.amount = amount;
        this.density = density;
        this.keepInfo = keepInfo;
        this.output = output.getItems()[0];
    }

    public DoliumRecipe(Fluid base, Fluid fluid, int amount, float density, boolean keep, ItemStack out, Collection<Pair<Ingredient, Integer>> items, Ingredient ext) {
        this.items = items != null ? new ArrayList<Pair<Ingredient, Integer>>(items) : new ArrayList<Pair<Ingredient, Integer>>();
        this.base = base;
        this.fluid = fluid;
        this.density = density;
        this.amount = amount;
        this.output = out;
        this.extra = ext;
        this.keepInfo = keep;
    }

    public static DoliumRecipe testPot(FluidStack fluidStack) {
        return recipes.stream().map(t -> (DoliumRecipe)t.value()).filter(t -> t.test(fluidStack, ItemStack.EMPTY, new ItemStack[0])).findFirst().orElse(null);
    }

    public static boolean testInput(ItemStack stack) {
        return recipes.stream().map(t -> (DoliumRecipe)t.value()).anyMatch(t -> t.items.stream().anyMatch(i -> ((Ingredient)i.getFirst()).test(stack)));
    }

    public static boolean testContainer(ItemStack stack) {
        return recipes.stream().map(t -> (DoliumRecipe)t.value()).map(t -> t.extra).filter(Objects::nonNull).anyMatch(t -> t.test(stack));
    }

    public static DoliumRecipe testDolium(FluidStack f, ItemStackHandler inv) {
        ItemStack is0 = inv.getStackInSlot(0);
        ItemStack is1 = inv.getStackInSlot(1);
        ItemStack is2 = inv.getStackInSlot(2);
        ItemStack cont = inv.getStackInSlot(4);
        return recipes.stream().map(t -> (DoliumRecipe)t.value()).filter(t -> t.test(f, cont, is0, is1, is2)).findFirst().orElse(null);
    }

    public boolean test(FluidStack f, ItemStack container, ItemStack ... ss) {
        if (this.items.size() > 0) {
            if (ss.length < this.items.size()) {
                return false;
            }
            int notEmpty = 0;
            for (ItemStack is : ss) {
                if (is.isEmpty()) continue;
                ++notEmpty;
            }
            if (notEmpty < this.items.size()) {
                return false;
            }
        }
        if (this.extra != null && !this.extra.test(container)) {
            return false;
        }
        if (!(this.fluid.isSame(Fluids.EMPTY) && f.isEmpty() || f.getFluid().isSame(this.fluid))) {
            return false;
        }
        if (this.amount > 0 && f.getAmount() < this.amount) {
            return false;
        }
        if (this.density != 0.0f || this.base != null) {
            StewInfo info = Utils.getOrCreateInfo(f);
            if (this.base != null && !info.base.equals(this.base)) {
                return false;
            }
            if (info.getDensity() < this.density) {
                return false;
            }
        }
        for (Pair<Ingredient, Integer> igd : this.items) {
            boolean flag = false;
            for (ItemStack is : ss) {
                if (!((Ingredient)igd.getFirst()).test(is) || is.getCount() < (Integer)igd.getSecond()) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    public ItemStack handle(FluidStack f) {
        int times = 1;
        if (this.amount > 0) {
            times = f.getAmount() / this.amount;
        }
        ItemStack out = this.output.copy();
        out.setCount(out.getCount() * times);
        if (this.keepInfo) {
            StewInfo info = Utils.getOrCreateInfo(f);
            Utils.setInfo((MutableDataComponentHolder)out, info);
        }
        f.shrink(times * this.amount);
        return out;
    }

    public ItemStack handleDolium(FluidStack f, ItemStackHandler inv) {
        ItemStack is;
        int i;
        int times = this.output.getMaxStackSize();
        if (this.amount > 0) {
            times = Math.min(f.getAmount() / this.amount, times);
        }
        if (this.extra != null) {
            times = Math.min(times, inv.getStackInSlot(4).getCount());
        }
        block0: for (Pair<Ingredient, Integer> igd : this.items) {
            if ((Integer)igd.getSecond() == 0) continue;
            for (i = 0; i < 3; ++i) {
                is = inv.getStackInSlot(i);
                if (!((Ingredient)igd.getFirst()).test(is)) continue;
                times = Math.min(times, is.getCount() / (Integer)igd.getSecond());
                continue block0;
            }
        }
        if (this.extra != null) {
            inv.getStackInSlot(4).shrink(times);
        }
        block2: for (Pair<Ingredient, Integer> igd : this.items) {
            if ((Integer)igd.getSecond() == 0) continue;
            for (i = 0; i < 3; ++i) {
                is = inv.getStackInSlot(i);
                if (!((Ingredient)igd.getFirst()).test(is)) continue;
                is.shrink(times * (Integer)igd.getSecond());
                continue block2;
            }
        }
        ItemStack out = this.output.copy();
        out.setCount(out.getCount() * times);
        if (this.keepInfo) {
            StewInfo info = Utils.getOrCreateInfo(f);
            Utils.setInfo((MutableDataComponentHolder)out, info);
        }
        if (this.amount > 0) {
            f.shrink(times * this.amount);
        }
        return out;
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Codec.list(Utils.pairCodec("item", Ingredient.CODEC_NONEMPTY, "count", Codec.INT)).fieldOf("items").forGetter(o -> o.items), (App)Ingredient.CODEC.optionalFieldOf("container").forGetter(o -> Optional.ofNullable(o.extra)), (App)BuiltInRegistries.FLUID.byNameCodec().optionalFieldOf("base").forGetter(o -> Optional.ofNullable(o.base)), (App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(o -> o.fluid), (App)Codec.INT.fieldOf("amount").forGetter(o -> o.amount), (App)Codec.FLOAT.fieldOf("density").forGetter(o -> Float.valueOf(o.density)), (App)Codec.BOOL.fieldOf("keepInfo").forGetter(o -> o.keepInfo), (App)Ingredient.CODEC_NONEMPTY.fieldOf("output").forGetter(o -> Ingredient.of((ItemStack[])new ItemStack[]{o.output}))).apply((Applicative)t, DoliumRecipe::new));
    }
}

