/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.components.ItemHoldedFluidData;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.util.Utils;
import java.util.Map;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BowlContainingRecipe
extends IDataRecipe {
    public static Map<Fluid, RecipeHolder<BowlContainingRecipe>> recipes;
    public static DeferredHolder<RecipeType<?>, RecipeType<Recipe<?>>> TYPE;
    public static DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SERIALIZER;
    public Item bowl;
    public Fluid fluid;
    public static final MapCodec<BowlContainingRecipe> CODEC;

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TYPE.get();
    }

    public BowlContainingRecipe(Item bowl, Fluid fluid) {
        this.bowl = bowl;
        this.fluid = fluid;
    }

    public ItemStack handle(Fluid f) {
        ItemStack is = new ItemStack((ItemLike)this.bowl);
        Utils.writeItemFluid(is, f);
        return is;
    }

    public boolean matches(Fluid f) {
        return this.fluid == f;
    }

    public ItemStack handle(FluidStack stack) {
        ItemStack is = new ItemStack((ItemLike)this.bowl);
        is.applyComponents((DataComponentMap)stack.getComponents());
        is.set(CPCapability.ITEM_FLUID, (Object)new ItemHoldedFluidData(stack.getFluid()));
        return is;
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(o -> o.bowl), (App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(o -> o.fluid)).apply((Applicative)t, BowlContainingRecipe::new));
    }
}

