/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.data.IDataRecipe;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AspicMeltingRecipe
extends IDataRecipe {
    public static List<RecipeHolder<AspicMeltingRecipe>> recipes;
    public static DeferredHolder<RecipeType<?>, RecipeType<Recipe<?>>> TYPE;
    public static DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SERIALIZER;
    public static final MapCodec<AspicMeltingRecipe> CODEC;
    public Ingredient aspic;
    public Fluid fluid;
    public int amount = 250;
    public int time = 100;

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TYPE.get();
    }

    public AspicMeltingRecipe(Ingredient aspic, Fluid fluid) {
        this.aspic = aspic;
        this.fluid = fluid;
    }

    public AspicMeltingRecipe(Ingredient aspic, Fluid fluid, int amount, int time) {
        this.aspic = aspic;
        this.fluid = fluid;
        this.amount = amount;
        this.time = time;
    }

    public FluidStack handle(ItemStack s) {
        StewInfo si = (StewInfo)s.get(CPCapability.STEW_INFO);
        FluidStack fs = new FluidStack(this.fluid, this.amount);
        fs.set(CPCapability.STEW_INFO, (Object)si);
        return fs;
    }

    public StewInfo info(ItemStack s) {
        StewInfo si = (StewInfo)s.get(CPCapability.STEW_INFO);
        return si;
    }

    public static AspicMeltingRecipe find(ItemStack aspic) {
        return recipes.stream().map(t -> (AspicMeltingRecipe)t.value()).filter(t -> t.aspic.test(aspic)).findFirst().orElse(null);
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Ingredient.CODEC.fieldOf("aspic").forGetter(o -> o.aspic), (App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(o -> o.fluid), (App)Codec.INT.fieldOf("amount").forGetter(o -> o.amount), (App)Codec.INT.fieldOf("time").forGetter(o -> o.time)).apply((Applicative)t, AspicMeltingRecipe::new));
    }
}

