/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddPoolLootModifier
extends LootModifier {
    public static final MapCodec<AddPoolLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> AddPoolLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.either((Codec)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE), (Codec)LootTable.DIRECT_CODEC).fieldOf("loot_table").forGetter(o -> o.lootTable)).apply((Applicative)inst, AddPoolLootModifier::new));
    Either<ResourceKey<LootTable>, LootTable> lootTable;

    protected AddPoolLootModifier(LootItemCondition[] conditionsIn, Either<ResourceKey<LootTable>, LootTable> table) {
        super(conditionsIn);
        this.lootTable = table;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LootTable lt = (LootTable)this.lootTable.map(o -> context.getResolver().get(Registries.LOOT_TABLE, o).map(Holder::value).orElse(LootTable.EMPTY), o -> o);
        lt.getRandomItemsRaw(new LootContext.Builder(context).withQueriedLootTableId(lt.getLootTableId()).create(null), arg_0 -> generatedLoot.add(arg_0));
        return generatedLoot;
    }

    public static Builder builder(ResourceLocation table) {
        return new Builder(table);
    }

    public static class Builder {
        List<LootItemCondition> cond = new ArrayList<LootItemCondition>();
        ResourceLocation table;

        Builder(ResourceLocation table) {
            this.table = table;
        }

        public Builder when(LootItemCondition.Builder builder) {
            this.cond.add(builder.build());
            return this;
        }

        public AddPoolLootModifier build() {
            return new AddPoolLootModifier((LootItemCondition[])this.cond.toArray(LootItemCondition[]::new), (Either<ResourceKey<LootTable>, LootTable>)Either.left((Object)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.table)));
        }
    }
}

