/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data;

import com.google.common.base.Stopwatch;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.data.recipes.AspicMeltingRecipe;
import com.teammoeg.caupona.data.recipes.BoilingRecipe;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.data.recipes.CountingTags;
import com.teammoeg.caupona.data.recipes.DissolveRecipe;
import com.teammoeg.caupona.data.recipes.DoliumRecipe;
import com.teammoeg.caupona.data.recipes.FluidFoodValueRecipe;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.data.recipes.SauteedRecipe;
import com.teammoeg.caupona.data.recipes.SpiceRecipe;
import com.teammoeg.caupona.data.recipes.StewCookingRecipe;
import com.teammoeg.caupona.data.recipes.baseconditions.BaseConditions;
import com.teammoeg.caupona.data.recipes.conditions.Conditions;
import com.teammoeg.caupona.data.recipes.numbers.Numbers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeReloadListener
implements ResourceManagerReloadListener {
    ReloadableServerResources data;
    public static final Logger logger = LogManager.getLogger((String)"Caupona recipe generator");
    RecipeManager clientRecipeManager;
    static int generated_fv = 0;

    public RecipeReloadListener(ReloadableServerResources dpr) {
        this.data = dpr;
    }

    public void onResourceManagerReload(@Nonnull ResourceManager resourceManager) {
        RecipeReloadListener.buildRecipeLists(this.data.getRecipeManager());
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (FoodValueRecipe.recipeset != null) {
            FoodValueRecipe.recipeset.forEach(FoodValueRecipe::clearCache);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        RecipeReloadListener.buildRecipeLists(event.getRecipeManager());
    }

    private static FoodValueRecipe addCookingTime(Item i, ItemStack iis, Set<Item> added, List<SmokingRecipe> irs, boolean force) {
        if (FoodValueRecipe.recipes.containsKey(i)) {
            return FoodValueRecipe.recipes.get(i);
        }
        added.add(i);
        for (SmokingRecipe sr : irs) {
            if (sr.getIngredients().size() <= 0 || !((Ingredient)sr.getIngredients().get(0)).test(iis)) continue;
            SingleRecipeInput fake = new SingleRecipeInput(iis);
            ItemStack reslt = sr.assemble(fake, (HolderLookup.Provider)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
            if (DissolveRecipe.recipes.stream().anyMatch(e -> ((DissolveRecipe)e.value()).test(reslt))) continue;
            if (added.contains(reslt.getItem())) break;
            FoodValueRecipe ret = RecipeReloadListener.addCookingTime(reslt.getItem(), reslt, added, irs, true);
            FoodProperties of = reslt.getFoodProperties(null);
            if (of != null && of.nutrition() > ret.heal) {
                ret.effects = of.effects();
                ret.heal = of.nutrition();
                ret.sat = of.saturation();
                ret.setRepersent(iis);
            }
            FoodValueRecipe.recipes.put(i, ret);
            ret.processtimes.put(i, sr.getCookingTime() + ret.processtimes.getOrDefault(reslt.getItem(), 0));
            return ret;
        }
        if (force) {
            FoodProperties of = iis.getFoodProperties(null);
            FoodValueRecipe ret = FoodValueRecipe.recipes.computeIfAbsent(i, e -> new FoodValueRecipe(0, 0.0f, iis, (Item)e));
            if (of != null && of.nutrition() > ret.heal) {
                ret.effects = of.effects();
                ret.heal = of.nutrition();
                ret.sat = of.saturation();
                ret.setRepersent(iis);
            }
            return ret;
        }
        return null;
    }

    public static void buildRecipeLists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.getRecipes();
        if (recipes.size() == 0) {
            return;
        }
        logger.info("Building recipes...");
        Stopwatch sw = Stopwatch.createStarted();
        Conditions.clearCache();
        Numbers.clearCache();
        BaseConditions.clearCache();
        BowlContainingRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, BowlContainingRecipe.class, BowlContainingRecipe.TYPE).collect(Collectors.toMap(e -> ((BowlContainingRecipe)e.value()).fluid, UnaryOperator.identity()));
        FoodValueRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, FoodValueRecipe.class, FoodValueRecipe.TYPE).flatMap(t -> ((FoodValueRecipe)t.value()).processtimes.keySet().stream().map(i -> new Pair(i, (Object)((FoodValueRecipe)t.value())))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        List<SmokingRecipe> irs = recipeManager.getAllRecipesFor(RecipeType.SMOKING).stream().map(t -> (SmokingRecipe)t.value()).toList();
        DissolveRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, DissolveRecipe.class, DissolveRecipe.TYPE).collect(Collectors.toList());
        BoilingRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, BoilingRecipe.class, BoilingRecipe.TYPE).collect(Collectors.toMap(e -> ((BoilingRecipe)e.value()).before, UnaryOperator.identity()));
        BoilingRecipe.allBoilables = BoilingRecipe.recipes.values().stream().flatMap(t -> Arrays.stream(new Fluid[]{((BoilingRecipe)t.value()).before, ((BoilingRecipe)t.value()).after})).collect(Collectors.toSet());
        FluidFoodValueRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, FluidFoodValueRecipe.class, FluidFoodValueRecipe.TYPE).collect(Collectors.toMap(e -> ((FluidFoodValueRecipe)e.value()).f, UnaryOperator.identity()));
        StewCookingRecipe.sorted = RecipeReloadListener.filterRecipes(recipes, StewCookingRecipe.class, StewCookingRecipe.TYPE).collect(Collectors.toList());
        StewCookingRecipe.sorted.sort((t2, t1) -> ((StewCookingRecipe)t1.value()).getPriority() - ((StewCookingRecipe)t2.value()).getPriority());
        StewCookingRecipe.cookables = StewCookingRecipe.sorted.stream().map(t -> (StewCookingRecipe)t.value()).flatMap(StewCookingRecipe::getAllNumbers).collect(Collectors.toSet());
        CountingTags.tags = Stream.concat(RecipeReloadListener.filterRecipes(recipes, CountingTags.class, CountingTags.TYPE).flatMap(r -> ((CountingTags)r.value()).tag.stream()), StewCookingRecipe.sorted.stream().map(t -> (StewCookingRecipe)t.value()).flatMap(StewCookingRecipe::getTags)).collect(Collectors.toSet());
        SauteedRecipe.sorted = RecipeReloadListener.filterRecipes(recipes, SauteedRecipe.class, SauteedRecipe.TYPE).collect(Collectors.toList());
        SauteedRecipe.sorted.sort((t2, t1) -> ((SauteedRecipe)t1.value()).getPriority() - ((SauteedRecipe)t2.value()).getPriority());
        SauteedRecipe.cookables = SauteedRecipe.sorted.stream().map(t -> (SauteedRecipe)t.value()).flatMap(SauteedRecipe::getAllNumbers).collect(Collectors.toSet());
        DoliumRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, DoliumRecipe.class, DoliumRecipe.TYPE).collect(Collectors.toList());
        DoliumRecipe.recipes.sort(((Comparator)(c1, c2) -> Integer.compare(((DoliumRecipe)c2.value()).items.size(), ((DoliumRecipe)c1.value()).items.size())).thenComparing((c1, c2) -> Integer.compare(((DoliumRecipe)c2.value()).items.stream().reduce(0, (a, b) -> a + (Integer)b.getSecond(), (a, b) -> a + b), ((DoliumRecipe)c1.value()).items.stream().reduce(0, (a, b) -> a + (Integer)b.getSecond(), (a, b) -> a + b))));
        AspicMeltingRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, AspicMeltingRecipe.class, AspicMeltingRecipe.TYPE).collect(Collectors.toList());
        SpiceRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, SpiceRecipe.class, SpiceRecipe.TYPE).map(t -> (SpiceRecipe)t.value()).collect(Collectors.toList());
        HashSet<Item> is = new HashSet<Item>();
        for (Item i : BuiltInRegistries.ITEM) {
            ItemStack iis = new ItemStack((ItemLike)i);
            if (FoodValueRecipe.recipes.containsKey(i) || DissolveRecipe.recipes.stream().anyMatch(e -> ((DissolveRecipe)e.value()).test(iis))) continue;
            RecipeReloadListener.addCookingTime(i, iis, is, irs, false);
        }
        FoodValueRecipe.recipeset = new HashSet<FoodValueRecipe>(FoodValueRecipe.recipes.values());
        sw.stop();
        logger.info("Recipes built, cost {}", (Object)sw);
    }

    static <R extends Recipe<?>> Stream<RecipeHolder<R>> filterRecipes(Collection<RecipeHolder<?>> recipes, Class<R> class1, DeferredHolder<RecipeType<?>, RecipeType<Recipe<?>>> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.value().getType() == recipeType.get()).map(t -> t);
    }
}

