/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.teammoeg.caupona.data.Deserializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class DataDeserializerRegistry<T> {
    private HashMap<String, Deserializer<? extends T>> deserializers = new HashMap();
    private List<Deserializer<? extends T>> byIdx = new ArrayList<Deserializer<? extends T>>();
    private HashMap<Class<?>, String> nameOfClass = new HashMap();

    public <R extends T> void register(String name, Deserializer<R> des) {
        this.deserializers.put(name, des);
    }

    public <R extends T> void register(String name, Class<R> cls, MapCodec<R> rjson, StreamCodec<RegistryFriendlyByteBuf, R> streamCodec) {
        Deserializer<R> des = new Deserializer<R>(rjson, streamCodec, this.byIdx.size());
        this.register(name, des);
        this.byIdx.add(des);
        this.nameOfClass.put(cls, name);
    }

    public Deserializer<? extends T> getDeserializer(String type) {
        return this.deserializers.get(type);
    }

    public T of(RegistryFriendlyByteBuf buffer) {
        return this.byIdx.get(buffer.readByte()).read(buffer);
    }

    public void clearCache() {
    }

    public MapCodec<? extends T> getCodec(String t) {
        Deserializer<T> des = this.getDeserializer(t);
        if (des == null) {
            return null;
        }
        return des.fromJson;
    }

    public byte getId(T t) {
        return (byte)this.deserializers.get(this.nameOfClass.get(t.getClass())).getId();
    }

    public StreamCodec<RegistryFriendlyByteBuf, ? extends T> getStreamCodec(byte t) {
        Deserializer<? extends T> des = this.byIdx.get(t);
        if (des == null) {
            return null;
        }
        return des.fromPacket;
    }

    public Codec<T> createCodec() {
        return Codec.STRING.dispatch("type", t -> t == null ? null : this.nameOfClass.get(t.getClass()), t -> this.getCodec((String)t));
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> createStreamCodec() {
        return ByteBufCodecs.BYTE.mapStream(t -> t).dispatch(t -> this.getId(t), t -> this.getStreamCodec((byte)t));
    }
}

