/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.container;

import com.teammoeg.caupona.CPGui;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.container.OutputSlot;
import com.teammoeg.caupona.data.recipes.AspicMeltingRecipe;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.util.INetworkContainer;
import com.teammoeg.caupona.util.ITickableContainer;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class PortableBrazierContainer
extends AbstractContainerMenu
implements INetworkContainer,
ITickableContainer {
    public static final int INGREDIENT = 0;
    private static final int CONTAINER = 1;
    private static final int FUEL = 2;
    private static final int OUT = 3;
    private final Player player;
    ItemStackHandler items = new ItemStackHandler(this, 4){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return AspicMeltingRecipe.find(stack) != null;
            }
            if (slot == 1) {
                return stack.is((Item)CPItems.water_bowl.get());
            }
            if (slot == 2) {
                return stack.is(CPTags.Items.PORTABLE_BRAZIER_FUEL_TYPE);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    ItemStack bowl = ItemStack.EMPTY;
    ItemStack aspic = ItemStack.EMPTY;
    ItemStack out = ItemStack.EMPTY;
    ItemStack pout = ItemStack.EMPTY;
    public int process;
    public int processMax;

    public PortableBrazierContainer(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory);
    }

    public PortableBrazierContainer(int id, Inventory playerInventory) {
        super((MenuType)CPGui.BRAZIER.get(), id);
        int i;
        this.player = playerInventory.player;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.items, 0, 44, 11));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.items, 1, 74, 11));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.items, 2, 74, 44));
        this.addSlot((Slot)new OutputSlot((IItemHandler)this.items, 3, 104, 11));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 83 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 141));
        }
    }

    private void sendUpdate() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("process", this.process);
        tag.putInt("processMax", this.processMax);
        this.sendMessage(tag);
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        if (!pPlayer.isAlive() || pPlayer instanceof ServerPlayer && ((ServerPlayer)pPlayer).hasDisconnected()) {
            for (int j = 0; j < this.items.getSlots(); ++j) {
                pPlayer.drop(this.items.getStackInSlot(j), false);
            }
            if (!this.bowl.isEmpty()) {
                pPlayer.drop(this.bowl, false);
            }
            if (!this.aspic.isEmpty()) {
                pPlayer.drop(this.aspic, false);
            }
            if (!this.out.isEmpty()) {
                pPlayer.drop(this.out, false);
            }
        } else {
            Inventory inventory = pPlayer.getInventory();
            if (inventory.player instanceof ServerPlayer) {
                for (int i = 0; i < this.items.getSlots(); ++i) {
                    inventory.placeItemBackInInventory(this.items.getStackInSlot(i));
                }
                if (!this.bowl.isEmpty()) {
                    inventory.placeItemBackInInventory(this.bowl);
                }
                if (!this.aspic.isEmpty()) {
                    inventory.placeItemBackInInventory(this.aspic);
                }
                if (!this.out.isEmpty()) {
                    inventory.placeItemBackInInventory(this.out);
                }
            }
        }
    }

    public boolean stillValid(Player pPlayer) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index == 3) {
                if (!this.moveItemStackTo(slotStack, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (index > 3 ? !this.moveItemStackTo(slotStack, 0, 3, false) && (index < 31 ? !this.moveItemStackTo(slotStack, 31, 40, false) : index < 40 && !this.moveItemStackTo(slotStack, 6, 31, false)) : !this.moveItemStackTo(slotStack, 6, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return itemStack;
    }

    @Override
    public void tick(boolean isServer) {
        if (isServer) {
            RecipeHolder<BowlContainingRecipe> recipe2;
            AspicMeltingRecipe recipe;
            if (this.processMax > 0) {
                ++this.process;
                if (this.process >= this.processMax) {
                    this.out = Utils.insertToOutput(this.items, 3, this.pout);
                    this.process = 0;
                    this.processMax = 0;
                    this.bowl = ItemStack.EMPTY;
                    this.aspic = ItemStack.EMPTY;
                    this.pout = ItemStack.EMPTY;
                }
                this.sendUpdate();
            }
            if (!this.out.isEmpty()) {
                this.out = Utils.insertToOutput(this.items, 3, this.out);
                return;
            }
            if (this.processMax == 0 && this.items.getStackInSlot(3).isEmpty() && !this.items.getStackInSlot(1).isEmpty() && this.items.getStackInSlot(2).is(CPTags.Items.PORTABLE_BRAZIER_FUEL_TYPE) && (recipe = AspicMeltingRecipe.find(this.items.getStackInSlot(0))) != null && (recipe2 = BowlContainingRecipe.recipes.get(recipe.fluid)) != null) {
                this.processMax = recipe.time;
                this.process = 0;
                this.bowl = this.items.getStackInSlot(1).split(1);
                this.aspic = this.items.getStackInSlot(0).split(1);
                this.items.getStackInSlot(2).shrink(1);
                this.pout = ((BowlContainingRecipe)recipe2.value()).handle(recipe.handle(this.aspic));
            }
        }
    }

    @Override
    public ServerPlayer getOpenedPlayer() {
        return (ServerPlayer)this.player;
    }

    @Override
    public void handle(CompoundTag nbt) {
        this.process = nbt.getInt("process");
        this.processMax = nbt.getInt("processMax");
    }
}

