/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.container;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class CPBaseContainer<T extends BlockEntity>
extends AbstractContainerMenu {
    protected T blockEntity;
    protected final int INV_START;
    protected static final int INV_SIZE = 36;
    protected static final int INV_QUICK = 27;

    public T getBlock() {
        return this.blockEntity;
    }

    protected CPBaseContainer(MenuType<?> pMenuType, T blockEntity, int pContainerId, int inv_start) {
        super(pMenuType, pContainerId);
        this.INV_START = inv_start;
        this.blockEntity = blockEntity;
    }

    protected void addPlayerInventory(Inventory inv, int dx, int dy, int quickBarY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, dx + j * 18, dy + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, dx + i * 18, quickBarY));
        }
    }

    public abstract boolean quickMoveIn(ItemStack var1);

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index < this.INV_START) {
                if (!this.moveItemStackTo(slotStack, this.INV_START, 36 + this.INV_START, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (index >= this.INV_START ? !this.quickMoveIn(slotStack) && (index < 27 + this.INV_START ? !this.moveItemStackTo(slotStack, 27 + this.INV_START, 36 + this.INV_START, false) : index < 36 + this.INV_START && !this.moveItemStackTo(slotStack, this.INV_START, 27 + this.INV_START, false)) : !this.moveItemStackTo(slotStack, this.INV_START, 36 + this.INV_START, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return itemStack;
    }

    public boolean stillValid(Player pPlayer) {
        return !this.blockEntity.isRemoved();
    }
}

