/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.components.IFoodInfo;
import com.teammoeg.caupona.data.recipes.FluidFoodValueRecipe;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.util.ChancedEffect;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.SerializeUtil;
import com.teammoeg.caupona.util.SpicedFoodInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class StewInfo
extends SpicedFoodInfo
implements IFoodInfo {
    public static Codec<StewInfo> CODEC = RecordCodecBuilder.create(t -> t.group(StewInfo.spiceCodec(), StewInfo.hasSpiceCodec(), StewInfo.spiceNameCodec(), (App)Codec.list(FloatemStack.CODEC).fieldOf("items").forGetter(o -> o.stacks), (App)Codec.list(SerializeUtil.fromRFBBStreamCodec(MobEffectInstance.STREAM_CODEC, MobEffectInstance.CODEC)).fieldOf("effects").forGetter(o -> o.effects), (App)Codec.list(ChancedEffect.CODEC).fieldOf("feffects").forGetter(o -> o.foodeffect), (App)Codec.INT.fieldOf("heal").forGetter(o -> o.healing), (App)Codec.FLOAT.fieldOf("sat").forGetter(o -> Float.valueOf(o.saturation)), (App)SerializeUtil.idOrKey(BuiltInRegistries.FLUID).fieldOf("base").forGetter(o -> o.base)).apply((Applicative)t, StewInfo::new));
    public List<FloatemStack> stacks;
    public List<MobEffectInstance> effects;
    public List<ChancedEffect> foodeffect = new ArrayList<ChancedEffect>();
    public int healing;
    public float saturation;
    public Fluid base;

    public StewInfo(Optional<MobEffectInstance> spice, Boolean hasSpice, Optional<ResourceLocation> spiceName, List<FloatemStack> stacks, List<MobEffectInstance> effects, List<ChancedEffect> foodeffect, int healing, float saturation, Fluid base) {
        super(spice, hasSpice, spiceName);
        this.stacks = new ArrayList<FloatemStack>(stacks);
        this.effects = new ArrayList<MobEffectInstance>(effects);
        this.foodeffect = new ArrayList<ChancedEffect>(foodeffect);
        this.healing = healing;
        this.saturation = saturation;
        this.base = base;
    }

    public StewInfo(List<FloatemStack> stacks, List<MobEffectInstance> effects, int healing, float saturation, Fluid base) {
        this.stacks = stacks;
        this.effects = effects;
        this.healing = healing;
        this.saturation = saturation;
        this.base = base;
    }

    public StewInfo(Fluid fluid) {
        this(new ArrayList<FloatemStack>(), new ArrayList<MobEffectInstance>(), 0, 0.0f, fluid);
    }

    public StewInfo() {
        this(new ArrayList<FloatemStack>(), new ArrayList<MobEffectInstance>(), 0, 0.0f, (Fluid)Fluids.WATER);
    }

    public StewInfo copy() {
        return new StewInfo(Optional.ofNullable(this.spice), this.hasSpice, Optional.ofNullable(this.spiceName), this.stacks.stream().map(t -> t.copy()).collect(Collectors.toList()), this.effects.stream().map(t -> new MobEffectInstance(t)).collect(Collectors.toList()), this.foodeffect.stream().map(t -> t.copy()).collect(Collectors.toList()), this.healing, this.saturation, this.base);
    }

    public float getDensity() {
        return this.stacks.stream().map(FloatemStack::getCount).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    public boolean canAlwaysEat() {
        return this.healing <= 1 || (double)this.getDensity() <= 0.5;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty() && this.effects.isEmpty();
    }

    public boolean canMerge(StewInfo f, float cparts, float oparts) {
        return (this.getDensity() * cparts + f.getDensity() * oparts) / (cparts + oparts) <= 3.0f;
    }

    public boolean merge(StewInfo f, float cparts, float oparts) {
        if (!this.canMerge(f, cparts, oparts)) {
            return false;
        }
        this.forceMerge(f, cparts, oparts);
        return true;
    }

    public void forceMerge(StewInfo f, float cparts, float oparts) {
        boolean added;
        for (MobEffectInstance mobEffectInstance : f.effects) {
            added = false;
            for (MobEffectInstance mobEffectInstance2 : this.effects) {
                if (!StewInfo.isEffectEquals(mobEffectInstance2, mobEffectInstance)) continue;
                mobEffectInstance2.duration = (int)((float)mobEffectInstance2.duration + (float)mobEffectInstance.duration * oparts / cparts);
                added = true;
                break;
            }
            if (added || this.effects.size() >= 3) continue;
            MobEffectInstance copy = new MobEffectInstance(mobEffectInstance);
            copy.duration = (int)((float)copy.duration * oparts / cparts);
            this.effects.add(copy);
        }
        for (ChancedEffect chancedEffect : f.foodeffect) {
            added = false;
            for (ChancedEffect chancedEffect2 : this.foodeffect) {
                if (!chancedEffect2.merge(chancedEffect, oparts, cparts)) continue;
                added = true;
                break;
            }
            if (added) continue;
            this.foodeffect.add(chancedEffect);
        }
        for (FloatemStack floatemStack : f.stacks) {
            this.addItem(new FloatemStack(floatemStack.getStack(), floatemStack.count * oparts / cparts));
        }
        this.completeAll();
    }

    public void completeAll() {
        this.clearSpice();
        this.completeData();
        this.completeEffects();
    }

    public void completeData() {
        this.stacks.sort(Comparator.comparingInt(e -> Item.getId((Item)e.getStack().getItem())));
        this.foodeffect.sort(Comparator.comparing(e -> e.effect.getEffect().getRegisteredName()).thenComparing(e -> Float.valueOf(e.chance)));
    }

    public void completeEffects() {
        this.effects.sort(Comparator.comparing(e -> e.getEffect().getRegisteredName()).thenComparingInt(e -> e.getDuration()));
    }

    public static boolean isEffectEquals(MobEffectInstance t1, MobEffectInstance t2) {
        return t1.getEffect() == t2.getEffect() && t1.getAmplifier() == t2.getAmplifier();
    }

    public void addEffect(MobEffectInstance eff, float parts) {
        for (MobEffectInstance oes : this.effects) {
            if (!StewInfo.isEffectEquals(oes, eff)) continue;
            oes.duration = Math.max(oes.duration, (int)Math.min((float)oes.duration + (float)eff.duration / parts, (float)eff.duration * 2.0f));
            return;
        }
        if (this.effects.size() < 3) {
            MobEffectInstance copy = new MobEffectInstance(eff);
            copy.duration = (int)((float)copy.duration / parts);
            this.effects.add(copy);
        }
    }

    public void recalculateHAS() {
        this.foodeffect.clear();
        float nh = 0.0f;
        float ns = 0.0f;
        for (FloatemStack fs : this.stacks) {
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(fs.getItem());
            if (fvr != null) {
                nh += (float)fvr.heal * fs.count;
                ns += fvr.sat * fs.count;
                if (fvr.effects == null) continue;
                fvr.effects.stream().map(ChancedEffect::new).forEach(this.foodeffect::add);
                continue;
            }
            FoodProperties f = fs.getStack().getFoodProperties(null);
            if (f == null) continue;
            nh += fs.count * (float)f.nutrition();
            ns += fs.count * f.saturation();
            f.effects().stream().map(ChancedEffect::new).forEach(this.foodeffect::add);
        }
        RecipeHolder<FluidFoodValueRecipe> ffvr = FluidFoodValueRecipe.recipes.get(this.base);
        if (ffvr != null) {
            nh += (float)(((FluidFoodValueRecipe)ffvr.value()).heal * 1);
            ns += ((FluidFoodValueRecipe)ffvr.value()).sat * 1.0f;
        }
        float dense = this.getDensity();
        int conv = (int)((double)Mth.clamp((float)((dense - 1.0f) / 2.0f), (float)0.0f, (float)1.0f) * 0.3 * (double)nh);
        this.healing = (int)Math.ceil(nh - (float)conv);
        this.saturation = this.healing > 0 ? Math.max(0.7f, (ns += (float)conv / 2.0f) / (float)this.healing / 2.0f) : 0.0f;
    }

    public void adjustParts(float oparts, float parts) {
        if (oparts == parts) {
            return;
        }
        for (FloatemStack floatemStack : this.stacks) {
            floatemStack.setCount(floatemStack.getCount() * oparts / parts);
        }
        for (MobEffectInstance mobEffectInstance : this.effects) {
            mobEffectInstance.duration = (int)((float)mobEffectInstance.duration * oparts / parts);
        }
        for (ChancedEffect chancedEffect : this.foodeffect) {
            chancedEffect.adjustParts(oparts, parts);
        }
        float delta = 0.0f;
        if (oparts > parts) {
            delta = oparts - parts;
        }
        this.clearSpice();
        this.healing = (int)((float)this.healing * oparts / parts);
        this.saturation = this.saturation * oparts / parts;
    }

    public void addItem(ItemStack is, float parts) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is)) continue;
            i.count += (float)is.getCount() / parts;
            return;
        }
        this.stacks.add(new FloatemStack(is.copy(), (float)is.getCount() / parts));
    }

    public void addItem(FloatemStack is) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is.getStack())) continue;
            i.count += is.count;
            return;
        }
        this.stacks.add(is);
    }

    @Override
    public List<FloatemStack> getStacks() {
        return this.stacks;
    }

    @Override
    public int getHealing() {
        return this.healing;
    }

    @Override
    public float getSaturation() {
        return this.saturation;
    }

    @Override
    public FoodProperties getFood() {
        FoodProperties.Builder b = new FoodProperties.Builder();
        for (MobEffectInstance eff : this.effects) {
            if (eff == null) continue;
            b.effect(eff, 1.0f);
        }
        if (this.spice != null) {
            b.effect(() -> new MobEffectInstance(this.spice), 1.0f);
        }
        for (ChancedEffect ef : this.foodeffect) {
            b.effect(ef.effectSupplier(), ef.chance);
        }
        b.nutrition(this.healing);
        if (Float.isNaN(this.saturation)) {
            b.saturationModifier(0.0f);
        } else {
            b.saturationModifier(this.saturation);
        }
        if (this.canAlwaysEat()) {
            b.alwaysEdible();
        }
        return b.build();
    }

    @Override
    public List<FoodProperties.PossibleEffect> getEffects() {
        ArrayList<FoodProperties.PossibleEffect> li = new ArrayList<FoodProperties.PossibleEffect>();
        for (MobEffectInstance eff : this.effects) {
            if (eff == null) continue;
            li.add(new FoodProperties.PossibleEffect(() -> new MobEffectInstance(eff), 1.0f));
        }
        if (this.spice != null) {
            li.add(new FoodProperties.PossibleEffect(() -> new MobEffectInstance(this.spice), 1.0f));
        }
        for (ChancedEffect ef : this.foodeffect) {
            li.add(new FoodProperties.PossibleEffect(ef.effectSupplier(), ef.chance));
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.base, this.effects, this.foodeffect, this.healing, Float.valueOf(this.saturation), this.stacks);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StewInfo other = (StewInfo)obj;
        return Objects.equals(this.base, other.base) && Objects.equals(this.effects, other.effects) && Objects.equals(this.foodeffect, other.foodeffect) && this.healing == other.healing && Float.floatToIntBits(this.saturation) == Float.floatToIntBits(other.saturation) && Objects.equals(this.stacks, other.stacks);
    }
}

