/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.components.IFoodInfo;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.util.ChancedEffect;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.SpicedFoodInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SauteedFoodInfo
extends SpicedFoodInfo
implements IFoodInfo {
    public static final Codec<SauteedFoodInfo> CODEC = RecordCodecBuilder.create(o -> SauteedFoodInfo.codecStart(o).and(o.group((App)Codec.list(FloatemStack.CODEC).fieldOf("items").forGetter(i -> i.stacks), (App)Codec.list(ChancedEffect.CODEC).fieldOf("effects").forGetter(i -> i.foodeffect), (App)Codec.INT.fieldOf("heal").forGetter(i -> i.healing), (App)Codec.FLOAT.fieldOf("sat").forGetter(i -> Float.valueOf(i.saturation)))).apply((Applicative)o, SauteedFoodInfo::new));
    public List<FloatemStack> stacks;
    public List<ChancedEffect> foodeffect = new ArrayList<ChancedEffect>();
    public int healing;
    public float saturation;

    public SauteedFoodInfo(Optional<MobEffectInstance> spice, Boolean hasSpice, Optional<ResourceLocation> spiceName, List<FloatemStack> stacks, List<ChancedEffect> foodeffect, int healing, float saturation) {
        super(spice, hasSpice, spiceName);
        this.stacks = new ArrayList<FloatemStack>(stacks);
        this.foodeffect = new ArrayList<ChancedEffect>(foodeffect);
        this.healing = healing;
        this.saturation = saturation;
    }

    public SauteedFoodInfo(List<FloatemStack> stacks, int healing, float saturation) {
        this.stacks = stacks;
        this.healing = healing;
        this.saturation = saturation;
    }

    public SauteedFoodInfo() {
        this(new ArrayList<FloatemStack>(), 0, 0.0f);
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public void completeAll() {
        this.completeData();
    }

    public void completeData() {
        this.stacks.sort(Comparator.comparingInt(e -> Item.getId((Item)e.getStack().getItem())));
        this.foodeffect.sort(Comparator.comparing(e -> e.effect.getEffect().getRegisteredName()).thenComparing(e -> Float.valueOf(e.chance)));
    }

    public static boolean isEffectEquals(MobEffectInstance t1, MobEffectInstance t2) {
        return t1.getEffect() == t2.getEffect() && t1.getAmplifier() == t2.getAmplifier();
    }

    public void recalculateHAS() {
        this.foodeffect.clear();
        float nh = 0.0f;
        float ns = 0.0f;
        for (FloatemStack fs : this.stacks) {
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(fs.getItem());
            if (fvr != null) {
                nh += (float)fvr.heal * fs.count;
                ns += fvr.sat * fs.count;
                if (fvr.effects == null) continue;
                fvr.effects.stream().map(ChancedEffect::new).forEach(this.foodeffect::add);
                continue;
            }
            FoodProperties f = fs.getStack().getFoodProperties(null);
            if (f == null) continue;
            nh += fs.count * (float)f.nutrition();
            ns += fs.count * f.saturation();
            f.effects().stream().map(ChancedEffect::new).forEach(this.foodeffect::add);
        }
        int conv = (int)(0.075 * (double)nh);
        this.healing = (int)Math.ceil(nh - (float)conv);
        this.saturation = this.healing > 0 ? Math.max(0.6f, (ns += (float)conv / 2.0f) / (float)this.healing / 2.0f) : 0.0f;
    }

    public void setParts(int parts) {
        for (FloatemStack i : this.stacks) {
            i.count /= (float)parts;
        }
    }

    public void addItem(ItemStack is) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is)) continue;
            i.count += (float)is.getCount();
            return;
        }
        this.stacks.add(new FloatemStack(is.copy(), is.getCount()));
    }

    public void addItem(FloatemStack is) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is.getStack())) continue;
            i.count += is.count;
            return;
        }
        this.stacks.add(is);
    }

    @Override
    public List<FloatemStack> getStacks() {
        return this.stacks;
    }

    @Override
    public int getHealing() {
        return this.healing;
    }

    @Override
    public float getSaturation() {
        return this.saturation;
    }

    @Override
    public FoodProperties getFood() {
        FoodProperties.Builder b = new FoodProperties.Builder();
        if (this.spice != null) {
            b.effect(() -> new MobEffectInstance(this.spice), 1.0f);
        }
        for (ChancedEffect ef : this.foodeffect) {
            b.effect(ef.effectSupplier(), ef.chance);
        }
        b.nutrition(this.healing);
        if (Float.isNaN(this.saturation)) {
            b.saturationModifier(0.0f);
        } else {
            b.saturationModifier(this.saturation);
        }
        return b.build();
    }

    @Override
    public List<FoodProperties.PossibleEffect> getEffects() {
        ArrayList<FoodProperties.PossibleEffect> li = new ArrayList<FoodProperties.PossibleEffect>();
        if (this.spice != null) {
            li.add(new FoodProperties.PossibleEffect(() -> new MobEffectInstance(this.spice), 1.0f));
        }
        for (ChancedEffect ef : this.foodeffect) {
            li.add(new FoodProperties.PossibleEffect(ef.effectSupplier(), ef.chance));
        }
        return null;
    }
}

