/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.compat.jei.category.IConditionalCategory;
import com.teammoeg.caupona.data.recipes.StewBaseCondition;
import com.teammoeg.caupona.data.recipes.StewCookingRecipe;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class StewCookingCategory
extends IConditionalCategory<StewCookingRecipe> {
    public static RecipeType<RecipeHolder> TYPE = RecipeType.create((String)"caupona", (String)"stew_cooking", RecipeHolder.class);
    private IDrawable ICON;
    private IGuiHelper helper;

    public StewCookingCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CPItems.anyWater.get()));
        this.helper = guiHelper;
    }

    public Component getTitle() {
        return Utils.translate("gui.jei.category.caupona.stew_cooking.title");
    }

    @Override
    public void drawCustom(RecipeHolder<StewCookingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        IDrawable density = (double)((StewCookingRecipe)recipe.value()).getDensity() < 0.4 ? DENSITY[0] : ((double)((StewCookingRecipe)recipe.value()).getDensity() < 0.6 ? DENSITY[1] : ((double)((StewCookingRecipe)recipe.value()).getDensity() < 0.8 ? DENSITY[2] : ((double)((StewCookingRecipe)recipe.value()).getDensity() < 1.2 ? DENSITY[3] : DENSITY[4])));
        density.draw(stack, 25, 15);
    }

    @Override
    public void draw(RecipeHolder<StewCookingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ResourceLocation imagePath = ResourceLocation.fromNamespaceAndPath((String)recipe.id().getNamespace(), (String)("textures/gui/recipes/" + recipe.id().getPath() + ".png"));
        if (Minecraft.getInstance().getResourceManager().getResource(imagePath).isPresent()) {
            PoseStack mstack = stack.pose();
            mstack.pushPose();
            mstack.scale(0.5f, 0.5f, 0.0f);
            this.helper.createDrawable(imagePath, 0, 0, 200, 210).draw(stack);
            mstack.popPose();
        } else {
            super.draw(recipe, recipeSlotsView, stack, mouseX, mouseY);
        }
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<StewCookingRecipe> recipe, IFocusGroup focuses) {
        if (((StewCookingRecipe)recipe.value()).getBase() != null && ((StewCookingRecipe)recipe.value()).getBase().size() > 0) {
            ArrayList<FluidStack> fss = new ArrayList<FluidStack>();
            for (Fluid f : BuiltInRegistries.FLUID) {
                for (StewBaseCondition base : ((StewCookingRecipe)recipe.value()).getBase()) {
                    if (!base.test(f)) continue;
                    fss.add(new FluidStack(f, 250));
                }
            }
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 30, 13).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fss)).setFluidRenderer(250L, false, 16, 16);
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 30, 13).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CPItems.any.get()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 18).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(((StewCookingRecipe)recipe.value()).output, 250))).setFluidRenderer(250L, false, 16, 16);
    }

    @Override
    public List<Component> getTooltipStrings(RecipeHolder<StewCookingRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (StewCookingCategory.inRange(mouseX, mouseY, 21, 6, 34, 30)) {
            return Arrays.asList(Utils.translate("recipe.caupona.density", Float.valueOf(((StewCookingRecipe)recipe.value()).getDensity())));
        }
        return super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
    }

    public RecipeType<RecipeHolder<StewCookingRecipe>> getRecipeType() {
        return TYPE;
    }

    @Override
    public IDrawable getHeadings() {
        return POT_HEADING;
    }
}

