/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei.category;

import com.teammoeg.caupona.data.recipes.AspicMeltingRecipe;
import com.teammoeg.caupona.util.Utils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class PotCategory
implements IRecipeCategory<RecipeHolder<AspicMeltingRecipe>> {
    public static RecipeType<RecipeHolder> TYPE = RecipeType.create((String)"caupona", (String)"aspic_thawing_pot", RecipeHolder.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;

    public PotCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"goulash"))));
        ResourceLocation guiMain = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/jei/aspic_thawing_pot.png");
        this.BACKGROUND = guiHelper.createDrawable(guiMain, 0, 0, 127, 63);
    }

    public Component getTitle() {
        return Utils.translate("gui.jei.category.caupona.thawing_pot.title");
    }

    public void draw(RecipeHolder<AspicMeltingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        String burnTime = String.valueOf((float)((AspicMeltingRecipe)recipe.value()).time / 20.0f) + "s";
        stack.drawString(Minecraft.getInstance().font, burnTime, 103, 55, 0xFFFFFF);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<AspicMeltingRecipe> recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 30, 28).addIngredients(((AspicMeltingRecipe)recipe.value()).aspic);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 83, 9).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(((AspicMeltingRecipe)recipe.value()).fluid, ((AspicMeltingRecipe)recipe.value()).amount))).setFluidRenderer(1250L, false, 16, 46);
    }

    public RecipeType<RecipeHolder<AspicMeltingRecipe>> getRecipeType() {
        return TYPE;
    }
}

