/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei.category;

import com.teammoeg.caupona.api.GameTranslation;
import com.teammoeg.caupona.api.events.DrawCustomConditionEvent;
import com.teammoeg.caupona.api.events.EventResult;
import com.teammoeg.caupona.data.recipes.IConditionalRecipe;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public abstract class IConditionalCategory<T extends IConditionalRecipe & Recipe<?>>
implements IRecipeCategory<RecipeHolder<T>> {
    private IDrawable BACKGROUND;
    private IGuiHelper helper;
    public static IDrawable COND_NONE;
    public static IDrawable COND_LIST;
    public static IDrawable COND_EXCEPT;
    public static IDrawable COND_HALF;
    public static IDrawable COND_MAINLY;
    public static IDrawable COND_MAINLY_LIST;
    public static IDrawable COND_HALF_LIST;
    public static IDrawable POT_HEADING;
    public static IDrawable PAN_HEADING;
    public static IDrawable[] DENSITY;
    public static IDrawable DETAIL;

    public IConditionalCategory(IGuiHelper guiHelper) {
        this.BACKGROUND = guiHelper.createBlankDrawable(100, 105);
        this.helper = guiHelper;
    }

    public static void init(IGuiHelper helper) {
        COND_NONE = IConditionalCategory.grid(helper, 4, 0);
        COND_EXCEPT = IConditionalCategory.grid(helper, 0, 0);
        COND_HALF = IConditionalCategory.grid(helper, 1, 0);
        COND_LIST = IConditionalCategory.grid(helper, 2, 0);
        COND_MAINLY = IConditionalCategory.grid(helper, 3, 0);
        COND_HALF_LIST = IConditionalCategory.grid(helper, 0, 1);
        COND_MAINLY_LIST = IConditionalCategory.grid(helper, 1, 1);
        PAN_HEADING = IConditionalCategory.grid(helper, 0, 2, 100, 52);
        POT_HEADING = IConditionalCategory.grid(helper, 0, 3, 100, 52);
        DENSITY = new IDrawable[5];
        IConditionalCategory.DENSITY[0] = IConditionalCategory.grid(helper, 0, 4, 0, 0, 26, 16);
        IConditionalCategory.DENSITY[1] = IConditionalCategory.grid(helper, 0, 4, 26, 0, 26, 16);
        IConditionalCategory.DENSITY[2] = IConditionalCategory.grid(helper, 0, 4, 52, 0, 26, 16);
        IConditionalCategory.DENSITY[3] = IConditionalCategory.grid(helper, 0, 4, 78, 0, 26, 16);
        IConditionalCategory.DENSITY[4] = IConditionalCategory.grid(helper, 0, 4, 104, 0, 26, 16);
        DETAIL = IConditionalCategory.grid(helper, 3, 1, 20, 20);
    }

    public static IDrawable grid(IGuiHelper helper, int x, int y) {
        return IConditionalCategory.grid(helper, x, y, 47, 53);
    }

    public static IDrawable grid(IGuiHelper helper, int x, int y, int w, int h) {
        return IConditionalCategory.grid(helper, x, y, 0, 0, w, h);
    }

    public static IDrawable grid(IGuiHelper helper, int x, int y, int dx, int dy, int w, int h) {
        return helper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/recipes/elements/recipe_page_elements.png"), x * 47 + dx, y * 53 + dy, w, h);
    }

    public abstract IDrawable getHeadings();

    public abstract void drawCustom(RecipeHolder<T> var1, IRecipeSlotsView var2, GuiGraphics var3, double var4, double var6);

    public void draw(RecipeHolder<T> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.getHeadings().draw(stack);
        this.drawConditionList(stack, ((IConditionalRecipe)recipe.value()).getAllow(), 1, 52);
        this.drawConditionList(stack, ((IConditionalRecipe)recipe.value()).getDeny(), 52, 52);
        this.drawCustom(recipe, recipeSlotsView, stack, mouseX, mouseY);
    }

    public boolean drawConditionList(GuiGraphics stack, List<IngredientCondition> conditions, int offX, int offY) {
        if (conditions == null || conditions.isEmpty()) {
            COND_NONE.draw(stack, offX, offY);
        } else {
            if (((DrawCustomConditionEvent)NeoForge.EVENT_BUS.post((Event)new DrawCustomConditionEvent(this.helper, conditions, stack, offX, offY))).getResult() == EventResult.DENY) {
                return false;
            }
            COND_LIST.draw(stack, offX, offY);
            DETAIL.draw(stack, offX + 13, offY + 14);
        }
        return false;
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public static boolean inRange(double x, double y, int ox, int oy, int w, int h) {
        return x > (double)ox && x < (double)(ox + w) && y > (double)oy && y < (double)(oy + h);
    }

    public List<Component> getTooltipStrings(RecipeHolder<T> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (IConditionalCategory.inRange(mouseX, mouseY, 0, 50, 100, 50)) {
            List<Component> allowence = null;
            List<IngredientCondition> conds = mouseX < 50.0 ? ((IConditionalRecipe)recipe.value()).getAllow() : ((IConditionalRecipe)recipe.value()).getDeny();
            if (conds != null) {
                allowence = conds.stream().map(e -> e.getTranslation(GameTranslation.get())).map(Utils::string).collect(Collectors.toList());
            }
            if (allowence != null && !allowence.isEmpty()) {
                if (mouseX < 50.0) {
                    allowence.add(0, (Component)Utils.translate("recipe.caupona.allow"));
                } else {
                    allowence.add(0, (Component)Utils.translate("recipe.caupona.deny"));
                }
                return allowence;
            }
        }
        return Arrays.asList(new Component[0]);
    }
}

