/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.compat.jei.category.IConditionalCategory;
import com.teammoeg.caupona.data.recipes.SauteedRecipe;
import com.teammoeg.caupona.util.Utils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class FryingCategory
extends IConditionalCategory<SauteedRecipe> {
    public static RecipeType<RecipeHolder> TYPE = RecipeType.create((String)"caupona", (String)"frying", RecipeHolder.class);
    private IDrawable ICON;
    private IGuiHelper helper;

    public FryingCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CPItems.gravy_boat.get()));
        this.helper = guiHelper;
    }

    public Component getTitle() {
        return Utils.translate("gui.jei.category.caupona.frying.title");
    }

    @Override
    public void draw(RecipeHolder<SauteedRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guistack, double mouseX, double mouseY) {
        PoseStack stack = guistack.pose();
        ResourceLocation imagePath = ResourceLocation.fromNamespaceAndPath((String)recipe.id().getNamespace(), (String)("textures/gui/recipes/" + recipe.id().getPath() + ".png"));
        if (Minecraft.getInstance().getResourceManager().getResource(imagePath).isPresent()) {
            stack.pushPose();
            stack.scale(0.5f, 0.5f, 0.0f);
            this.helper.createDrawable(imagePath, 0, 0, 200, 210).draw(guistack);
            stack.popPose();
        } else {
            super.draw(recipe, recipeSlotsView, guistack, mouseX, mouseY);
        }
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<SauteedRecipe> recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 30, 13).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CPItems.gravy_boat.get()));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 18).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)((SauteedRecipe)recipe.value()).output))).addTooltipCallback((v, t) -> t.add(Utils.translate("gui.jei.category.caupona.ingredientPer", Float.valueOf(((SauteedRecipe)recipe.value()).count))));
    }

    public RecipeType<RecipeHolder<SauteedRecipe>> getRecipeType() {
        return TYPE;
    }

    @Override
    public IDrawable getHeadings() {
        return PAN_HEADING;
    }

    @Override
    public void drawCustom(RecipeHolder<SauteedRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
    }
}

