/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei.category;

import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.compat.jei.category.BaseCallback;
import com.teammoeg.caupona.data.recipes.DoliumRecipe;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class DoliumRestingCategory
implements IRecipeCategory<RecipeHolder<DoliumRecipe>> {
    public static RecipeType<RecipeHolder> TYPE = RecipeType.create((String)"caupona", (String)"dolium_resting", RecipeHolder.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;

    public DoliumRestingCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CPBlocks.dolium.get(0)));
        ResourceLocation guiMain = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/jei/maximum_resting.png");
        this.BACKGROUND = guiHelper.createDrawable(guiMain, 0, 0, 127, 63);
    }

    public Component getTitle() {
        return Utils.translate("gui.jei.category.caupona.resting.title");
    }

    public void draw(RecipeHolder<DoliumRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        String burnTime = String.valueOf((float)((Integer)CPConfig.COMMON.staticTime.get()).intValue() / 20.0f) + "s";
        stack.drawString(Minecraft.getInstance().font, burnTime, 100, 55, 0xFFFFFF);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    private static List<ItemStack> unpack(Pair<Ingredient, Integer> ps) {
        ArrayList<ItemStack> sl = new ArrayList<ItemStack>();
        for (ItemStack is : ((Ingredient)ps.getFirst()).getItems()) {
            sl.add(is.copyWithCount((Integer)ps.getSecond() > 0 ? (Integer)ps.getSecond() : 1));
        }
        return sl;
    }

    private static List<ItemStack> unpack(Ingredient ps) {
        if (ps.getClass() != Ingredient.class) {
            return Arrays.asList(ps.getItems());
        }
        ArrayList<ItemStack> sl = new ArrayList<ItemStack>();
        for (ItemStack is : ps.getItems()) {
            if (is.isDamageableItem()) {
                for (int i = 0; i <= is.getMaxDamage(); ++i) {
                    ItemStack iss = is.copy();
                    iss.setDamageValue(i);
                    sl.add(iss);
                }
                continue;
            }
            sl.add(is);
        }
        return sl;
    }

    private static RecipeIngredientRole type(Pair<Ingredient, Integer> ps) {
        return (Integer)ps.getSecond() == 0 ? RecipeIngredientRole.CATALYST : RecipeIngredientRole.INPUT;
    }

    private static CatalistCallback cb(Pair<Ingredient, Integer> ps) {
        return new CatalistCallback((Integer)ps.getSecond());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<DoliumRecipe> recipe, IFocusGroup focuses) {
        if (((DoliumRecipe)recipe.value()).items.size() > 0) {
            ((IRecipeSlotBuilder)builder.addSlot(DoliumRestingCategory.type(((DoliumRecipe)recipe.value()).items.get(0)), 4, 6).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DoliumRestingCategory.unpack(((DoliumRecipe)recipe.value()).items.get(0)))).addTooltipCallback((IRecipeSlotTooltipCallback)DoliumRestingCategory.cb(((DoliumRecipe)recipe.value()).items.get(0)));
            if (((DoliumRecipe)recipe.value()).items.size() > 1) {
                ((IRecipeSlotBuilder)builder.addSlot(DoliumRestingCategory.type(((DoliumRecipe)recipe.value()).items.get(1)), 4, 24).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DoliumRestingCategory.unpack(((DoliumRecipe)recipe.value()).items.get(1)))).addTooltipCallback((IRecipeSlotTooltipCallback)DoliumRestingCategory.cb(((DoliumRecipe)recipe.value()).items.get(1)));
                if (((DoliumRecipe)recipe.value()).items.size() > 2) {
                    ((IRecipeSlotBuilder)builder.addSlot(DoliumRestingCategory.type(((DoliumRecipe)recipe.value()).items.get(2)), 4, 42).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DoliumRestingCategory.unpack(((DoliumRecipe)recipe.value()).items.get(2)))).addTooltipCallback((IRecipeSlotTooltipCallback)DoliumRestingCategory.cb(((DoliumRecipe)recipe.value()).items.get(2)));
                }
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 24).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((DoliumRecipe)recipe.value()).output);
        if (((DoliumRecipe)recipe.value()).extra != null) {
            builder.addSlot(RecipeIngredientRole.INPUT, 89, 10).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DoliumRestingCategory.unpack(((DoliumRecipe)recipe.value()).extra));
        }
        if (((DoliumRecipe)recipe.value()).fluid != Fluids.EMPTY) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 9).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(((DoliumRecipe)recipe.value()).fluid, ((DoliumRecipe)recipe.value()).amount))).setFluidRenderer(1250L, false, 16, 46).addTooltipCallback((IRecipeSlotTooltipCallback)new BaseCallback(((DoliumRecipe)recipe.value()).base, ((DoliumRecipe)recipe.value()).density));
        }
    }

    public RecipeType<RecipeHolder<DoliumRecipe>> getRecipeType() {
        return TYPE;
    }

    private static class CatalistCallback
    implements IRecipeSlotTooltipCallback {
        int cnt;

        public CatalistCallback(int cnt) {
            this.cnt = cnt;
        }

        public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
            if (this.cnt == 0) {
                tooltip.add((Component)Utils.translate("gui.jei.category.caupona.catalyst"));
            }
        }
    }
}

