/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei.category;

import com.teammoeg.caupona.data.recipes.BoilingRecipe;
import com.teammoeg.caupona.util.Utils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class BoilingCategory
implements IRecipeCategory<RecipeHolder<BoilingRecipe>> {
    public static RecipeType<RecipeHolder> TYPE = RecipeType.create((String)"caupona", (String)"boiling", RecipeHolder.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;

    public BoilingCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"nail_soup"))));
        ResourceLocation guiMain = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/jei/boiling.png");
        this.BACKGROUND = guiHelper.createDrawable(guiMain, 0, 0, 127, 63);
    }

    public Component getTitle() {
        return Utils.translate("gui.jei.category.caupona.boiling.title");
    }

    public void draw(RecipeHolder<BoilingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        String burnTime = String.valueOf((float)((BoilingRecipe)recipe.value()).time / 20.0f) + "s";
        stack.drawString(Minecraft.getInstance().font, burnTime, 103, 55, 0xFFFFFF);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<BoilingRecipe> recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 30, 9).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(((BoilingRecipe)recipe.value()).before, 250))).setFluidRenderer(1250L, false, 16, 46);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 83, 9).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(((BoilingRecipe)recipe.value()).after, 250))).setFluidRenderer(1250L, false, 16, 46);
    }

    public RecipeType<RecipeHolder<BoilingRecipe>> getRecipeType() {
        return TYPE;
    }
}

