/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.teammoeg.caupona.client.util.DisplayGroupProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class LayeredBakedModel
implements BakedModel {
    protected Map<String, int[]> faces;
    protected List<BakedQuad> unculledFaces;
    protected final boolean hasAmbientOcclusion;
    protected final boolean isGui3d;
    protected final boolean usesBlockLight;
    protected final TextureAtlasSprite particleIcon;
    protected final ItemTransforms transforms;
    protected final ItemOverrides overrides;
    public final int cacheNo = 0;
    protected final ChunkRenderTypeSet blockRenderTypes;
    protected final List<RenderType> itemRenderTypes;
    protected final List<RenderType> fabulousItemRenderTypes;
    private final Function<Map.Entry<String, int[]>, int[]> values;
    private final Function<int[], IntStream> istr;
    private final IntFunction<BakedQuad> tobaked;

    public LayeredBakedModel(List<BakedQuad> pUnculledFaces, boolean pHasAmbientOcclusion, boolean pUsesBlockLight, boolean pIsGui3d, TextureAtlasSprite pParticleIcon, ItemTransforms pTransforms, ItemOverrides pOverrides) {
        this(pUnculledFaces, new HashMap<String, int[]>(), pHasAmbientOcclusion, pUsesBlockLight, pIsGui3d, pParticleIcon, pTransforms, pOverrides, RenderTypeGroup.EMPTY);
    }

    public LayeredBakedModel(List<BakedQuad> pUnculledFaces, Map<String, int[]> names, boolean pHasAmbientOcclusion, boolean pUsesBlockLight, boolean pIsGui3d, TextureAtlasSprite pParticleIcon, ItemTransforms pTransforms, ItemOverrides pOverrides, RenderTypeGroup renderTypes) {
        this.unculledFaces = pUnculledFaces;
        this.hasAmbientOcclusion = pHasAmbientOcclusion;
        this.isGui3d = pIsGui3d;
        this.usesBlockLight = pUsesBlockLight;
        this.particleIcon = pParticleIcon;
        this.transforms = pTransforms;
        this.overrides = pOverrides;
        this.faces = names;
        this.blockRenderTypes = !renderTypes.isEmpty() ? ChunkRenderTypeSet.of((RenderType[])new RenderType[]{renderTypes.block()}) : null;
        this.itemRenderTypes = !renderTypes.isEmpty() ? List.of(renderTypes.entity()) : null;
        this.fabulousItemRenderTypes = !renderTypes.isEmpty() ? List.of(renderTypes.entityFabulous()) : null;
        this.values = Map.Entry::getValue;
        this.istr = Arrays::stream;
        this.tobaked = this.unculledFaces::get;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        ImmutableSet groups = (ImmutableSet)data.get((ModelProperty)DisplayGroupProperty.PROPERTY);
        if (groups != null) {
            return this.faces.entrySet().stream().filter(e -> groups.contains(e.getKey())).map(this.values).flatMapToInt(this.istr).distinct().mapToObj(this.tobaked).collect(Collectors.toUnmodifiableList());
        }
        return this.unculledFaces;
    }

    public boolean useAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }

    public boolean isGui3d() {
        return this.isGui3d;
    }

    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particleIcon;
    }

    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (this.blockRenderTypes != null) {
            return this.blockRenderTypes;
        }
        return super.getRenderTypes(state, rand, data);
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        if (!fabulous) {
            if (this.itemRenderTypes != null) {
                return this.itemRenderTypes;
            }
        } else if (this.fabulousItemRenderTypes != null) {
            return this.fabulousItemRenderTypes;
        }
        return super.getRenderTypes(itemStack, fabulous);
    }

    public List<BakedQuad> getQuads(BlockState pState, Direction pDirection, RandomSource pRandom) {
        if (pDirection != null) {
            return List.of();
        }
        return this.unculledFaces;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<BakedQuad> unculledFaces = Lists.newArrayList();
        private final Map<String, Set<Integer>> faces = new HashMap<String, Set<Integer>>();
        private final ItemOverrides overrides;
        private final boolean hasAmbientOcclusion;
        private TextureAtlasSprite particleIcon;
        private final boolean usesBlockLight;
        private final boolean isGui3d;
        private final ItemTransforms transforms;

        public Builder(BlockModel pBlockModel, ItemOverrides pOverrides, boolean pIsGui3d) {
            this(pBlockModel.hasAmbientOcclusion(), pBlockModel.getGuiLight().lightLikeBlock(), pIsGui3d, pBlockModel.getTransforms(), pOverrides);
        }

        public Builder(boolean pHasAmbientOcclusion, boolean pUsesBlockLight, boolean pIsGui3d, ItemTransforms pTransforms, ItemOverrides pOverrides) {
            this.overrides = pOverrides;
            this.hasAmbientOcclusion = pHasAmbientOcclusion;
            this.usesBlockLight = pUsesBlockLight;
            this.isGui3d = pIsGui3d;
            this.transforms = pTransforms;
        }

        public Builder addUnculledFace(BakedQuad pQuad, Iterable<String> groups) {
            int idx = this.unculledFaces.size();
            this.unculledFaces.add(pQuad);
            for (String group : groups) {
                this.faces.computeIfAbsent(group, e -> new LinkedHashSet()).add(idx);
            }
            return this;
        }

        public Builder particle(TextureAtlasSprite pParticleIcon) {
            this.particleIcon = pParticleIcon;
            return this;
        }

        public Builder item() {
            return this;
        }

        public BakedModel build(RenderTypeGroup renderTypes) {
            HashMap<String, int[]> rfaces = new HashMap<String, int[]>();
            ToIntFunction<Integer> identity = e -> e;
            for (Map.Entry<String, Set<Integer>> k : this.faces.entrySet()) {
                rfaces.put(k.getKey(), k.getValue().stream().mapToInt(identity).toArray());
            }
            return new LayeredBakedModel(this.unculledFaces, rfaces, this.hasAmbientOcclusion, this.usesBlockLight, this.isGui3d, this.particleIcon, this.transforms, this.overrides, renderTypes);
        }
    }
}

