/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;

public class GuiUtils {
    public static Quaternionf rotate90 = new Quaternionf(new AxisAngle4f(1.5707964f, 1.0f, 0.0f, 0.0f));
    private static final Function<ResourceLocation, RenderType> GUI_CUTOUT = Util.memoize(texture -> RenderType.create((String)("gui_" + String.valueOf(texture)), (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderType.LIGHTMAP).setShaderState(RenderType.RENDERTYPE_CUTOUT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderType.BLOCK_SHEET).createCompositeState(true)));

    private GuiUtils() {
    }

    public static void handleGuiTank(GuiGraphics transform, IFluidTank tank, int x, int y, int w, int h) {
        FluidStack fluid = tank.getFluid();
        MultiBufferSource.BufferSource buffer = transform.bufferSource();
        if (fluid != null && fluid.getFluid() != null) {
            int fluidHeight = (int)((float)h * ((float)fluid.getAmount() / (float)tank.getCapacity()));
            GuiUtils.drawRepeatedFluidSpriteGui(buffer, transform.pose(), fluid, x, y + h - fluidHeight, w, fluidHeight);
        }
        buffer.endBatch();
    }

    private static void buildVertex(VertexConsumer bu, PoseStack transform, float r, float g, float b, float a, float p1, float p2, float u0, float u1, int light, int overlay) {
        bu.addVertex(transform.last().pose(), p1, p2, 0.0f).setColor(r, g, b, a).setUv(u0, u1).setOverlay(overlay).setLight(light).setNormal(1.0f, 1.0f, 1.0f);
    }

    public static void drawRepeatedFluidSpriteGui(MultiBufferSource.BufferSource buffer, PoseStack transform, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = GUI_CUTOUT.apply(InventoryMenu.BLOCK_ATLAS);
        VertexConsumer builder = buffer.getBuffer(renderType);
        IClientFluidTypeExtensions attr = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(attr.getStillTexture(fluid));
        int col = attr.getTintColor(fluid);
        float alpha = (float)(col >> 16 & 0xFF) / 255.0f * 0.8f;
        if ((double)alpha < 0.001) {
            alpha = 1.0f;
        }
        GuiUtils.drawRepeatedSprite(builder, transform, x, y, w, h, 16, 16, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, alpha, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        buffer.endBatch(renderType);
    }

    public static void drawRepeatedSprite(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha, int light, int overlay) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiUtils.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax, light, overlay);
            }
            GuiUtils.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf, light, overlay);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiUtils.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax, light, overlay);
            }
            GuiUtils.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf, light, overlay);
        }
    }

    public static void drawTexturedColoredRect(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1, int light, int overlay) {
        GuiUtils.buildVertex(builder, transform, r, g, b, alpha, x, y + h, u0, v1, light, overlay);
        GuiUtils.buildVertex(builder, transform, r, g, b, alpha, x + w, y + h, u1, v1, light, overlay);
        GuiUtils.buildVertex(builder, transform, r, g, b, alpha, x + w, y, u1, v0, light, overlay);
        GuiUtils.buildVertex(builder, transform, r, g, b, alpha, x, y, u0, v0, light, overlay);
    }
}

