/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;

public class DynamicRenderLevel
implements BlockAndTintGetter {
    Level lvl;
    BlockPos center;
    Direction.Axis rotationAxis;

    public DynamicRenderLevel(Level lvl, BlockPos center, Direction.Axis rotationAxis) {
        this.lvl = lvl;
        this.center = center;
        this.rotationAxis = rotationAxis;
    }

    public BlockPos getDelta() {
        return this.center.above();
    }

    public BlockEntity getBlockEntity(BlockPos pPos) {
        Direction dir;
        BlockPos dpos = pPos.subtract((Vec3i)this.center);
        if (Math.abs(dpos.getX()) <= 1 && Math.abs(dpos.getY()) <= 1 && Math.abs(dpos.getZ()) <= 1 && (dir = Direction.fromDelta((int)dpos.getX(), (int)dpos.getY(), (int)dpos.getZ())).getAxis() != this.rotationAxis) {
            return this.lvl.getBlockEntity(this.getDelta());
        }
        return this.lvl.getBlockEntity(pPos);
    }

    public BlockState getBlockState(BlockPos pPos) {
        Direction dir;
        BlockPos dpos = pPos.subtract((Vec3i)this.center);
        if (Math.abs(dpos.getX()) <= 1 && Math.abs(dpos.getY()) <= 1 && Math.abs(dpos.getZ()) <= 1 && (dir = Direction.fromDelta((int)dpos.getX(), (int)dpos.getY(), (int)dpos.getZ())).getAxis() != this.rotationAxis) {
            return this.lvl.getBlockState(this.getDelta());
        }
        return this.lvl.getBlockState(pPos);
    }

    public FluidState getFluidState(BlockPos pPos) {
        Direction dir;
        BlockPos dpos = pPos.subtract((Vec3i)this.center);
        if (Math.abs(dpos.getX()) <= 1 && Math.abs(dpos.getY()) <= 1 && Math.abs(dpos.getZ()) <= 1 && (dir = Direction.fromDelta((int)dpos.getX(), (int)dpos.getY(), (int)dpos.getZ())).getAxis() != this.rotationAxis) {
            return this.lvl.getFluidState(this.getDelta());
        }
        return this.lvl.getFluidState(pPos);
    }

    public int getHeight() {
        return this.lvl.getHeight();
    }

    public int getMinBuildHeight() {
        return this.lvl.getMinBuildHeight();
    }

    public float getShade(Direction pDirection, boolean pShade) {
        return this.lvl.getShade(pDirection, pShade);
    }

    public LevelLightEngine getLightEngine() {
        return this.lvl.getLightEngine();
    }

    public int getBlockTint(BlockPos pBlockPos, ColorResolver pColorResolver) {
        Direction dir;
        BlockPos dpos = pBlockPos.subtract((Vec3i)this.center);
        if (Math.abs(dpos.getX()) <= 1 && Math.abs(dpos.getY()) <= 1 && Math.abs(dpos.getZ()) <= 1 && (dir = Direction.fromDelta((int)dpos.getX(), (int)dpos.getY(), (int)dpos.getZ())).getAxis() != this.rotationAxis) {
            return this.lvl.getBlockTint(this.getDelta(), pColorResolver);
        }
        return this.lvl.getBlockTint(pBlockPos, pColorResolver);
    }
}

