/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.util;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.client.model.data.ModelData;

public class DynamicBlockModelReference
implements Supplier<BakedModel>,
Function<ModelData, List<BakedQuad>> {
    private final ModelResourceLocation name;
    private static final RandomSource RANDOM_SOURCE = RandomSource.create();

    public DynamicBlockModelReference(String name) {
        this.name = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)("block/dynamic/" + name)));
    }

    public DynamicBlockModelReference(ResourceLocation rl) {
        this.name = ModelResourceLocation.standalone((ResourceLocation)rl);
    }

    @Override
    public BakedModel get() {
        return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getModelManager().getModel(this.name);
    }

    public List<BakedQuad> getAllQuads() {
        return this.apply(ModelData.EMPTY);
    }

    @Override
    public List<BakedQuad> apply(ModelData data) {
        return this.get().getQuads(null, null, RANDOM_SOURCE, data, null);
    }

    public static RandomSource getRandomSource() {
        return RANDOM_SOURCE;
    }

    static {
        RANDOM_SOURCE.setSeed(42L);
    }
}

