/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teammoeg.caupona.blocks.pot.StewPot;
import com.teammoeg.caupona.blocks.pot.StewPotBlockEntity;
import com.teammoeg.caupona.client.util.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Vector3f;

public class StewPotRenderer
implements BlockEntityRenderer<StewPotBlockEntity> {
    public StewPotRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    private static Vector3f clr(int fromcol, int tocol, float proc) {
        float fcolr = (float)(fromcol >> 16 & 0xFF) / 255.0f;
        float fcolg = (float)(fromcol >> 8 & 0xFF) / 255.0f;
        float fcolb = (float)(fromcol & 0xFF) / 255.0f;
        float tcolr = (float)(tocol >> 16 & 0xFF) / 255.0f;
        float tcolg = (float)(tocol >> 8 & 0xFF) / 255.0f;
        float tcolb = (float)(tocol & 0xFF) / 255.0f;
        return new Vector3f(fcolr + (tcolr - fcolr) * proc, fcolg + (tcolg - fcolg) * proc, fcolb + (tcolb - fcolb) * proc);
    }

    private static Vector3f clr(int col) {
        return new Vector3f((float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f);
    }

    public void render(StewPotBlockEntity blockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!blockEntity.getLevel().hasChunkAt(blockEntity.getBlockPos())) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        if (!(state.getBlock() instanceof StewPot)) {
            return;
        }
        matrixStack.pushPose();
        FluidStack fs = blockEntity.getTank().getFluid();
        if (fs != null && !fs.isEmpty() && fs.getFluid() != null) {
            Vector3f clr;
            float rr = fs.getAmount();
            if (blockEntity.proctype == 2) {
                rr += 250.0f * (1.0f - (float)blockEntity.process * 1.0f / (float)blockEntity.processMax);
            }
            float yy = Math.min(1.0f, rr / (float)blockEntity.getTank().getCapacity()) * 0.5f + 0.1875f;
            matrixStack.translate(0.0f, yy, 0.0f);
            matrixStack.mulPose(GuiUtils.rotate90);
            VertexConsumer builder = buffer.getBuffer(RenderType.translucent());
            IClientFluidTypeExtensions attr0 = IClientFluidTypeExtensions.of((Fluid)fs.getFluid());
            TextureAtlas atlas = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
            TextureAtlasSprite sprite = atlas.getSprite(attr0.getStillTexture(fs));
            int col = attr0.getTintColor(fs);
            float alp = 1.0f;
            if (blockEntity.output != null && !blockEntity.output.isEmpty() && blockEntity.processMax > 0) {
                IClientFluidTypeExtensions attr1 = IClientFluidTypeExtensions.of((Fluid)blockEntity.output.getFluid());
                TextureAtlasSprite sprite2 = atlas.getSprite(attr1.getStillTexture(fs));
                float proc = (float)blockEntity.process * 1.0f / (float)blockEntity.processMax;
                clr = StewPotRenderer.clr(col, attr1.getTintColor(fs), proc);
                alp = 1.0f - proc;
                GuiUtils.drawTexturedColoredRect(builder, matrixStack, 0.125f, 0.125f, 0.75f, 0.75f, clr.x(), clr.y(), clr.z(), proc, sprite2.getU0(), sprite2.getU1(), sprite2.getV0(), sprite2.getV1(), combinedLightIn, combinedOverlayIn);
            } else {
                clr = StewPotRenderer.clr(col);
            }
            GuiUtils.drawTexturedColoredRect(builder, matrixStack, 0.125f, 0.125f, 0.75f, 0.75f, clr.x(), clr.y(), clr.z(), alp, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), combinedLightIn, combinedOverlayIn);
        }
        matrixStack.popPose();
    }
}

