/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.components.MosaicData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MosaicRenderer
extends BlockEntityWithoutLevelRenderer {
    public MosaicRenderer() {
        super(null, null);
    }

    public void renderByItem(ItemStack is, ItemDisplayContext ctx, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        @Nullable MosaicData tag = (MosaicData)is.get(CPCapability.MOSAIC_DATA);
        if (tag == null) {
            return;
        }
        BlockState bs = tag.createBlock();
        BlockRenderDispatcher rd = Minecraft.getInstance().getBlockRenderer();
        BakedModel bm = rd.getBlockModel(bs);
        ItemRenderer ir = Minecraft.getInstance().getItemRenderer();
        VertexConsumer pBuffer = buffer.getBuffer(RenderType.cutout());
        RandomSource randomsource = RandomSource.create();
        for (Direction direction : Direction.values()) {
            randomsource.setSeed(42L);
            ir.renderQuadList(matrixStack, pBuffer, bm.getQuads(bs, direction, randomsource), is, combinedLightIn, combinedOverlayIn);
        }
        randomsource.setSeed(42L);
        ir.renderQuadList(matrixStack, pBuffer, bm.getQuads(bs, (Direction)null, randomsource), is, combinedLightIn, combinedOverlayIn);
    }
}

