/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.blocks.dolium.CounterDoliumBlockEntity;
import com.teammoeg.caupona.client.util.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class CounterDoliumRenderer
implements BlockEntityRenderer<CounterDoliumBlockEntity> {
    public CounterDoliumRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(CounterDoliumBlockEntity blockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!blockEntity.getLevel().hasChunkAt(blockEntity.getBlockPos())) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        if (!CPBlocks.dolium.contains(state.getBlock())) {
            return;
        }
        if (blockEntity.tank.isEmpty()) {
            return;
        }
        FluidStack fs = blockEntity.tank.getFluid();
        matrixStack.pushPose();
        if (fs != null && !fs.isEmpty() && fs.getFluid() != null) {
            float rr = (float)fs.getAmount() / 1250.0f * 0.5f + 0.375f;
            matrixStack.translate(0.0f, rr, 0.0f);
            matrixStack.mulPose(GuiUtils.rotate90);
            VertexConsumer builder = buffer.getBuffer(RenderType.translucent());
            IClientFluidTypeExtensions attr = IClientFluidTypeExtensions.of((Fluid)fs.getFluid());
            TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(attr.getStillTexture(fs));
            int col = attr.getTintColor(fs);
            float alp = 1.0f;
            GuiUtils.drawTexturedColoredRect(builder, matrixStack, 0.125f, 0.125f, 0.75f, 0.75f, (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, alp, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), combinedLightIn, combinedOverlayIn);
        }
        matrixStack.popPose();
    }
}

