/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.blocks.foods.BowlBlockEntity;
import com.teammoeg.caupona.client.util.GuiUtils;
import com.teammoeg.caupona.item.StewItem;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class BowlRenderer
implements BlockEntityRenderer<BowlBlockEntity> {
    public BowlRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(BowlBlockEntity blockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!blockEntity.getLevel().hasChunkAt(blockEntity.getBlockPos())) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        if (state.getBlock() != CPBlocks.BOWL.get()) {
            return;
        }
        if (blockEntity.internal == null || !(blockEntity.internal.getItem() instanceof StewItem)) {
            return;
        }
        FluidStack fs = Utils.extractFluid(blockEntity.internal);
        matrixStack.pushPose();
        if (fs != null && !fs.isEmpty() && fs.getFluid() != null) {
            matrixStack.translate(0.0f, 0.28125f, 0.0f);
            matrixStack.mulPose(GuiUtils.rotate90);
            IClientFluidTypeExtensions attr = IClientFluidTypeExtensions.of((Fluid)fs.getFluid());
            VertexConsumer builder = buffer.getBuffer(RenderType.translucent());
            TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(attr.getStillTexture(fs));
            int col = attr.getTintColor(fs);
            float alp = 1.0f;
            GuiUtils.drawTexturedColoredRect(builder, matrixStack, 0.28125f, 0.28125f, 0.4375f, 0.4375f, (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, alp, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), combinedLightIn, combinedOverlayIn);
        }
        matrixStack.popPose();
    }
}

