/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.gui;

import com.teammoeg.caupona.blocks.decoration.mosaic.TBenchMenu;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TBenchScreen
extends AbstractContainerScreen<TBenchMenu> {
    private static final ResourceLocation BG_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/tessellation_workbench.png");
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int RECIPES_X = 52;
    private static final int RECIPES_Y = 14;

    public TBenchScreen(TBenchMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        --this.titleLabelY;
    }

    public void render(GuiGraphics p_281735_, int p_282517_, int p_282840_, float p_282389_) {
        super.render(p_281735_, p_282517_, p_282840_, p_282389_);
        this.renderTooltip(p_281735_, p_282517_, p_282840_);
    }

    protected void renderBg(GuiGraphics p_283115_, float p_282453_, int p_282940_, int p_282328_) {
        int i = this.leftPos;
        int j = this.topPos;
        p_283115_.blit(BG_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int l = this.leftPos + 52;
        int i1 = this.topPos + 14;
        this.renderButtons(p_283115_, p_282940_, p_282328_, l, i1);
        this.renderRecipes(p_283115_, l, i1);
    }

    protected void renderTooltip(GuiGraphics p_282396_, int p_283157_, int p_282258_) {
        super.renderTooltip(p_282396_, p_283157_, p_282258_);
        if (!((TBenchMenu)this.menu).getRecipes().isEmpty()) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            List<ItemStack> list = ((TBenchMenu)this.menu).getRecipes();
            for (int l = 0; l < ((TBenchMenu)this.menu).getNumRecipes(); ++l) {
                int j1 = i + l % 4 * 16;
                int k1 = j + l / 4 * 18 + 2;
                if (p_283157_ < j1 || p_283157_ >= j1 + 16 || p_282258_ < k1 || p_282258_ >= k1 + 18) continue;
                p_282396_.renderTooltip(this.font, list.get(l), p_283157_, p_282258_);
            }
        }
    }

    private void renderButtons(GuiGraphics p_282733_, int p_282136_, int p_282147_, int p_281987_, int p_281276_) {
        for (int i = 0; i < ((TBenchMenu)this.menu).getNumRecipes(); ++i) {
            int k = p_281987_ + i % 4 * 16;
            int l = i / 4;
            int i1 = p_281276_ + l * 18 + 2;
            int j1 = this.imageHeight;
            if (i == ((TBenchMenu)this.menu).getSelectedRecipeIndex()) {
                j1 += 18;
            } else if (p_282136_ >= k && p_282147_ >= i1 && p_282136_ < k + 16 && p_282147_ < i1 + 18) {
                j1 += 36;
            }
            p_282733_.blit(BG_LOCATION, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics p_281999_, int p_282658_, int p_282563_) {
        List<ItemStack> list = ((TBenchMenu)this.menu).getRecipes();
        for (int i = 0; i < ((TBenchMenu)this.menu).getNumRecipes(); ++i) {
            int k = p_282658_ + i % 4 * 16;
            int l = i / 4;
            int i1 = p_282563_ + l * 18 + 2;
            p_281999_.renderItem(list.get(i), k, i1);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (!((TBenchMenu)this.menu).getRecipes().isEmpty()) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            for (int l = 0; l < 12; ++l) {
                double d0 = pMouseX - (double)(i + l % 4 * 16);
                double d1 = pMouseY - (double)(j + l / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((TBenchMenu)this.menu).clickMenuButton((Player)this.minecraft.player, l)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((TBenchMenu)this.menu).containerId, l);
                return true;
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }
}

