/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.blocks.pot.StewPotBlockEntity;
import com.teammoeg.caupona.blocks.pot.StewPotContainer;
import com.teammoeg.caupona.client.gui.ImageButton;
import com.teammoeg.caupona.client.util.GuiUtils;
import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.IFluidTank;

public class StewPotScreen
extends AbstractContainerScreen<StewPotContainer> {
    private ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/stew_pot.png");
    private int TEXT_COLOR = -2456213;
    StewPotBlockEntity blockEntity;
    public static MutableComponent start = Utils.translate("gui.caupona.stewpot.canstart");
    public static MutableComponent started = Utils.translate("gui.caupona.stewpot.started");
    public static MutableComponent nostart = Utils.translate("gui.caupona.stewpot.cantstart");
    public static MutableComponent nors = Utils.translate("gui.caupona.stewpot.noredstone");
    public static MutableComponent rs = Utils.translate("gui.caupona.stewpot.redstone");
    private ArrayList<Component> tooltip = new ArrayList(2);
    ImageButton btn1;
    ImageButton btn2;

    public StewPotScreen(StewPotContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        if (((StewPotBlockEntity)container.getBlock()).getBlockState().is((Block)CPBlocks.STEW_POT_LEAD.get())) {
            this.TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/lead_stew_pot.png");
            this.TEXT_COLOR = -1772814;
        } else {
            this.TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/stew_pot.png");
            this.TEXT_COLOR = -2456213;
        }
        this.titleLabelY = 4;
        this.titleLabelX = 7;
        this.inventoryLabelY = this.imageHeight - 92;
        this.inventoryLabelX = 4;
        this.blockEntity = (StewPotBlockEntity)container.getBlock();
    }

    public void init() {
        super.init();
        this.clearWidgets();
        this.btn1 = new ImageButton(Button.builder((Component)start, btn -> {
            if (this.btn1.state == 0) {
                this.blockEntity.sendMessage((short)0, 0);
            }
        }).pos(this.leftPos + 7, this.topPos + 48).size(20, 12), 176, 83, 256, 256, this.TEXTURE, () -> this.btn1.state == 0 ? Tooltip.create((Component)start) : Tooltip.create((Component)started));
        this.addRenderableWidget((GuiEventListener)this.btn1);
        this.btn2 = new ImageButton(Button.builder((Component)rs, btn -> this.blockEntity.sendMessage((short)1, this.btn2.state)).pos(this.leftPos + 7, this.topPos + 61).size(20, 20), 176, 107, 256, 256, this.TEXTURE, () -> this.btn2.state == 2 ? Tooltip.create((Component)rs) : Tooltip.create((Component)nors));
        this.addRenderableWidget((GuiEventListener)this.btn2);
    }

    public void render(GuiGraphics transform, int mouseX, int mouseY, float partial) {
        this.tooltip.clear();
        this.btn1.state = this.blockEntity.proctype > 0 ? 1 : 0;
        this.btn2.state = this.blockEntity.rsstate ? 1 : 2;
        super.render(transform, mouseX, mouseY, partial);
        if (this.blockEntity.proctype < 2 && !this.blockEntity.getTank().isEmpty()) {
            if (this.isMouseIn(mouseX, mouseY, 105, 20, 16, 46)) {
                this.tooltip.add(this.blockEntity.getTank().getFluid().getHoverName());
                StewInfo si = Utils.getOrCreateInfo(this.blockEntity.getTank().getFluid());
                FloatemStack fs = si.stacks.stream().max((t1, t2) -> t1.getCount() > t2.getCount() ? 1 : (t1.getCount() == t2.getCount() ? 0 : -1)).orElse(null);
                if (fs != null) {
                    this.tooltip.add((Component)Utils.translate("tooltip.caupona.main_ingredient", fs.getStack().getDisplayName()));
                }
                Utils.addPotionTooltip(si.effects, this.tooltip::add, 1.0f, this.blockEntity.getLevel());
            }
            GuiUtils.handleGuiTank(transform, (IFluidTank)this.blockEntity.getTank(), this.leftPos + 105, this.topPos + 20, 16, 46);
        }
        if (!this.tooltip.isEmpty()) {
            transform.renderTooltip(this.font, this.tooltip, Optional.empty(), mouseX, mouseY);
        } else {
            super.renderTooltip(transform, mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics matrixStack, int x, int y) {
        matrixStack.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, this.TEXT_COLOR, false);
        Component name = this.playerInventoryTitle;
        int w = this.font.width(name.getString());
        matrixStack.drawString(this.font, name, this.imageWidth - w - this.inventoryLabelX, this.inventoryLabelY, this.TEXT_COLOR, false);
    }

    protected void renderBg(GuiGraphics transform, float partial, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        transform.blit(this.TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.blockEntity.processMax > 0 && this.blockEntity.process > 0) {
            int h = (int)(29.0f * ((float)this.blockEntity.process / (float)this.blockEntity.processMax));
            transform.blit(this.TEXTURE, this.leftPos + 9, this.topPos + 17 + h, 176, 54 + h, 16, 29 - h);
        }
        if (this.blockEntity.proctype > 1) {
            if (this.blockEntity.proctype == 2) {
                transform.blit(this.TEXTURE, this.leftPos + 44, this.topPos + 16, 176, 0, 54, 54);
            }
            transform.blit(this.TEXTURE, this.leftPos + 102, this.topPos + 17, 230, 0, 21, 51);
        }
    }

    public boolean isMouseIn(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= this.leftPos + x && mouseY >= this.topPos + y && mouseX < this.leftPos + x + w && mouseY < this.topPos + y + h;
    }
}

