/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teammoeg.caupona.container.PortableBrazierContainer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PortableBrazierScreen
extends AbstractContainerScreen<PortableBrazierContainer> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/portable_brazier.png");
    PortableBrazierContainer container;

    public PortableBrazierScreen(PortableBrazierContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    protected void renderLabels(GuiGraphics matrixStack, int x, int y) {
        matrixStack.drawString(this.font, this.title, this.titleLabelX - 2, this.titleLabelY, 0xEEEEEE, false);
        matrixStack.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX - 2, this.inventoryLabelY - 3, 0x404040, false);
    }

    protected void renderBg(GuiGraphics transform, float partial, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        transform.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.container.processMax > 0) {
            int h = (int)(29.0f * ((float)this.container.process / (float)this.container.processMax));
            transform.blit(TEXTURE, this.leftPos + 116, this.topPos + 36 + h, 176, 1 + h, 16, 29 - h);
        }
    }

    public boolean isMouseIn(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= this.leftPos + x && mouseY >= this.topPos + y && mouseX < this.leftPos + x + w && mouseY < this.topPos + y + h;
    }

    public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        super.renderTooltip(pPoseStack, pMouseX, pMouseY);
    }
}

