/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teammoeg.caupona.blocks.stove.KitchenStoveBlockEntity;
import com.teammoeg.caupona.blocks.stove.KitchenStoveContainer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class KitchenStoveScreen
extends AbstractContainerScreen<KitchenStoveContainer> {
    KitchenStoveBlockEntity blockEntity;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/kitchen_stove.png");

    public KitchenStoveScreen(KitchenStoveContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.blockEntity = (KitchenStoveBlockEntity)screenContainer.getBlock();
    }

    public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pPoseStack, pMouseX, pMouseY);
    }

    protected void renderLabels(GuiGraphics matrixStack, int x, int y) {
        matrixStack.drawString(this.font, this.title, this.titleLabelX - 2, this.titleLabelY, 0xEEEEEE, false);
        matrixStack.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX - 2, this.inventoryLabelY - 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics matrixStack, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.blockEntity.processMax > 0 && this.blockEntity.process > 0) {
            int h = (int)(26.0f * (1.0f - (float)this.blockEntity.process / (float)this.blockEntity.processMax));
            matrixStack.blit(TEXTURE, this.leftPos + 61, this.topPos + h, 176, h, 54, 26 - h);
            switch (this.blockEntity.last) {
                case CHARCOAL: {
                    matrixStack.blit(TEXTURE, this.leftPos + 61, this.topPos + 13, 176, 42, 54, 16);
                    break;
                }
                case WOODS: {
                    matrixStack.blit(TEXTURE, this.leftPos + 61, this.topPos + 13, 176, 58, 54, 16);
                    break;
                }
                default: {
                    matrixStack.blit(TEXTURE, this.leftPos + 61, this.topPos + 13, 176, 26, 54, 16);
                }
            }
        }
    }
}

