/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teammoeg.caupona.blocks.dolium.CounterDoliumBlockEntity;
import com.teammoeg.caupona.blocks.dolium.DoliumContainer;
import com.teammoeg.caupona.client.util.GuiUtils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.fluids.IFluidTank;

public class DoliumScreen
extends AbstractContainerScreen<DoliumContainer> {
    public final CounterDoliumBlockEntity blockEntity;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"textures/gui/counter_with_dolium.png");
    private ArrayList<Component> tooltip = new ArrayList(2);

    public DoliumScreen(DoliumContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.blockEntity = (CounterDoliumBlockEntity)screenContainer.getBlock();
    }

    public void render(GuiGraphics transform, int mouseX, int mouseY, float partial) {
        this.tooltip.clear();
        super.render(transform, mouseX, mouseY, partial);
        if (!this.blockEntity.tank.isEmpty()) {
            if (this.isMouseIn(mouseX, mouseY, 80, 27, 16, 46)) {
                this.tooltip.add(this.blockEntity.tank.getFluid().getHoverName());
            }
            GuiUtils.handleGuiTank(transform, (IFluidTank)this.blockEntity.tank, this.leftPos + 80, this.topPos + 27, 16, 46);
        }
        if (!this.tooltip.isEmpty()) {
            transform.renderTooltip(this.font, this.tooltip, Optional.empty(), mouseX, mouseY);
        } else {
            super.renderTooltip(transform, mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics matrixStack, int x, int y) {
        matrixStack.drawString(this.font, this.title, this.titleLabelX - 2, this.titleLabelY, 0xEEEEEE, false);
        matrixStack.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX - 2, this.inventoryLabelY - 3, 0x404040, false);
    }

    protected void renderBg(GuiGraphics transform, float partial, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        transform.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.blockEntity.process > 0) {
            int w = (int)(12.0f * ((float)this.blockEntity.process / (float)this.blockEntity.processMax));
            transform.blit(TEXTURE, this.leftPos + 117, this.topPos + 32, 176, 0, w, 25);
        }
    }

    public boolean isMouseIn(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= this.leftPos + x && mouseY >= this.topPos + y && mouseX < this.leftPos + x + w && mouseY < this.topPos + y + h;
    }
}

