/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPEntityTypes;
import com.teammoeg.caupona.CPGui;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicBlock;
import com.teammoeg.caupona.client.CPParticles;
import com.teammoeg.caupona.client.gui.DoliumScreen;
import com.teammoeg.caupona.client.gui.KitchenStoveScreen;
import com.teammoeg.caupona.client.gui.PanScreen;
import com.teammoeg.caupona.client.gui.PortableBrazierScreen;
import com.teammoeg.caupona.client.gui.StewPotScreen;
import com.teammoeg.caupona.client.gui.TBenchScreen;
import com.teammoeg.caupona.client.particle.SootParticle;
import com.teammoeg.caupona.client.particle.SteamParticle;
import com.teammoeg.caupona.client.renderer.BowlRenderer;
import com.teammoeg.caupona.client.renderer.CPBoatRenderer;
import com.teammoeg.caupona.client.renderer.CounterDoliumRenderer;
import com.teammoeg.caupona.client.renderer.MosaicRenderer;
import com.teammoeg.caupona.client.renderer.PanRenderer;
import com.teammoeg.caupona.client.renderer.StewPotRenderer;
import com.teammoeg.caupona.generated.CPStewTexture;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(value={Dist.CLIENT}, modid="caupona", bus=EventBusSubscriber.Bus.MOD)
public class CPClientRegistry {
    private static final ResourceLocation STILL_WATER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"block/water_still");

    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent event) {
        LayerDefinition layer = BoatModel.createBodyModel();
        for (String wood : CPBlocks.woods) {
            ClientHooks.registerLayerDefinition((ModelLayerLocation)new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)("boat/" + wood)), "main"), () -> layer);
        }
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CPBlockEntityTypes.STEW_POT.get()), StewPotRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CPBlockEntityTypes.BOWL.get()), BowlRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CPBlockEntityTypes.SIGN.get()), SignRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CPBlockEntityTypes.DOLIUM.get()), CounterDoliumRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CPBlockEntityTypes.PAN.get()), PanRenderer::new);
        Sheets.addWoodType((WoodType)CPBlocks.WALNUT);
        EntityRenderers.register((EntityType)((EntityType)CPEntityTypes.BOAT.get()), c -> new CPBoatRenderer(c, false));
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterMenuScreensEvent event) {
        event.register((MenuType)CPGui.STEWPOT.get(), StewPotScreen::new);
        event.register((MenuType)CPGui.STOVE.get(), KitchenStoveScreen::new);
        event.register((MenuType)CPGui.DOLIUM.get(), DoliumScreen::new);
        event.register((MenuType)CPGui.BRAZIER.get(), PortableBrazierScreen::new);
        event.register((MenuType)CPGui.PAN.get(), PanScreen::new);
        event.register((MenuType)CPGui.T_BENCH.get(), TBenchScreen::new);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            MosaicRenderer renderer = new MosaicRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        }, new Item[]{((MosaicBlock)((Object)CPBlocks.MOSAIC.get())).asItem()});
        for (String i : CPItems.soups) {
            final ResourceLocation rt = CPStewTexture.texture.getOrDefault(i, STILL_WATER_TEXTURE);
            final int cx = -1;
            event.registerFluidType(new IClientFluidTypeExtensions(){

                public int getTintColor() {
                    return cx;
                }

                public ResourceLocation getStillTexture() {
                    return rt;
                }

                public ResourceLocation getFlowingTexture() {
                    return rt;
                }
            }, new FluidType[]{(FluidType)NeoForgeRegistries.FLUID_TYPES.get(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)i))});
        }
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)CPParticles.STEAM.get(), SteamParticle.Factory::new);
        event.registerSpriteSet((ParticleType)CPParticles.SOOT.get(), SootParticle.Factory::new);
    }

    @SubscribeEvent
    public static void onTint(RegisterColorHandlersEvent.Block ev) {
        ev.register((p_92626_, p_92627_, p_92628_, p_92629_) -> p_92627_ != null && p_92628_ != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)p_92627_, (BlockPos)p_92628_) : FoliageColor.getDefaultColor(), (Block[])CPBlocks.leaves.stream().map(t -> (Block)t.value()).toArray(Block[]::new));
    }

    @SubscribeEvent
    public static void onTint(RegisterColorHandlersEvent.Item ev) {
        ev.register((i, t) -> 6018121, (ItemLike[])CPBlocks.leaves.stream().map(t -> (Block)t.value()).toArray(Block[]::new));
    }
}

