/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.stove;

import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.stove.ChimneyPotBlockEntity;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.blocks.stove.KitchenStove;
import com.teammoeg.caupona.blocks.stove.KitchenStoveContainer;
import com.teammoeg.caupona.client.CPParticles;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.ChimneyHelper;
import com.teammoeg.caupona.util.FuelType;
import com.teammoeg.caupona.util.IInfinitable;
import com.teammoeg.caupona.util.Utils;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class KitchenStoveBlockEntity
extends CPBaseBlockEntity
implements Container,
MenuProvider,
IStove,
IInfinitable {
    private NonNullList<ItemStack> fuel = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    public int process;
    public int processMax;
    private final int speed;
    private final int maxcd;
    private int cd;
    private float fuelMod = 1.0f;
    public BlockPos attachedChimney;
    private int chimneyTicks = 0;
    private int chimneyCheckTicks = 20;
    boolean isInfinite = false;
    public FuelType last = FuelType.OTHER;

    public KitchenStoveBlockEntity(BlockEntityType<KitchenStoveBlockEntity> tet, BlockPos p, BlockState s, int spd) {
        super(tet, p, s);
        this.speed = spd;
        this.maxcd = (Integer)CPConfig.SERVER.stoveCD.get() / this.speed;
        this.fuelMod = (float)((Double)CPConfig.SERVER.stoveFuel.get()).doubleValue();
        this.chimneyCheckTicks = (Integer)CPConfig.SERVER.chimneyCheck.get();
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        this.process = nbt.getInt("process");
        this.processMax = nbt.getInt("processMax");
        this.attachedChimney = nbt.contains("chimneyPos") ? BlockPos.of((long)nbt.getLong("chimneyPos")) : null;
        this.last = FuelType.values()[nbt.getInt("fuel_type")];
        if (!isClient) {
            this.cd = nbt.getInt("cd");
            this.fuel.set(0, (Object)ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("fuel")));
            this.chimneyTicks = nbt.getInt("chimneyTick");
            this.isInfinite = nbt.getBoolean("inf");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        nbt.putInt("process", this.process);
        nbt.putInt("processMax", this.processMax);
        if (this.attachedChimney != null) {
            nbt.putLong("chimneyPos", this.attachedChimney.asLong());
        }
        nbt.putInt("fuel_type", this.last.ordinal());
        if (!isClient) {
            nbt.putInt("cd", this.cd);
            nbt.put("fuel", ((ItemStack)this.fuel.get(0)).saveOptional(registries));
            nbt.putInt("chimneyTick", this.chimneyTicks);
            nbt.putBoolean("inf", this.isInfinite);
        }
    }

    public void clearContent() {
        this.fuel.clear();
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return ((ItemStack)this.fuel.get(0)).isEmpty();
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.fuel.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.fuel, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.fuel, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        this.fuel.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.fuel.get(0);
        return stack.getBurnTime(RecipeType.SMELTING) > 0 && itemstack.getCraftingRemainingItem().isEmpty();
    }

    public AbstractContainerMenu createMenu(int a, Inventory b, Player c) {
        return new KitchenStoveContainer(a, b, this);
    }

    public Component getDisplayName() {
        return Utils.translate("container.caupona.kitchen_stove.title");
    }

    private boolean consumeFuel() {
        int time = ((ItemStack)this.fuel.get(0)).getBurnTime(RecipeType.SMELTING);
        if (time <= 0) {
            this.processMax = 0;
            this.process = 0;
            return false;
        }
        this.last = FuelType.getType((ItemStack)this.fuel.get(0));
        ((ItemStack)this.fuel.get(0)).shrink(1);
        float ftime = (float)time * this.fuelMod / (float)this.speed;
        float frac = Mth.frac((float)ftime);
        this.processMax = frac > 0.0f ? (this.process = (int)ftime + (this.level.random.nextDouble() < (double)frac ? 1 : 0)) : (this.process = (int)ftime);
        return true;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            BlockState bs = this.getBlockState();
            boolean syncNeeded = false;
            ++this.chimneyTicks;
            if (this.chimneyTicks >= this.chimneyCheckTicks) {
                this.chimneyTicks = 0;
                BlockPos newChimney = ChimneyHelper.getNearestChimney(this.getLevel(), this.getBlockPos(), 2);
                if (!Objects.equals(newChimney, this.attachedChimney)) {
                    this.attachedChimney = newChimney;
                    syncNeeded = true;
                }
            }
            boolean flag = false;
            if (this.process <= 0 && (((Boolean)bs.getValue((Property)KitchenStove.LIT)).booleanValue() || ((Boolean)bs.getValue((Property)KitchenStove.ASH)).booleanValue())) {
                bs = (BlockState)((BlockState)bs.setValue((Property)KitchenStove.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)KitchenStove.ASH, (Comparable)Boolean.valueOf(false));
                flag = true;
            }
            int fs = (Integer)bs.getValue((Property)KitchenStove.FUELED);
            if (!((ItemStack)this.fuel.get(0)).isEmpty()) {
                FuelType type = FuelType.getType((ItemStack)this.fuel.get(0));
                if (type.getModelId() != fs) {
                    flag = true;
                    bs = (BlockState)bs.setValue((Property)KitchenStove.FUELED, (Comparable)Integer.valueOf(type.getModelId()));
                }
            } else if (fs != 0) {
                flag = true;
                bs = (BlockState)bs.setValue((Property)KitchenStove.FUELED, (Comparable)Integer.valueOf(0));
            }
            if (this.process > 0) {
                if (!((Boolean)bs.getValue((Property)KitchenStove.ASH)).booleanValue()) {
                    flag = true;
                    bs = (BlockState)bs.setValue((Property)KitchenStove.ASH, (Comparable)Boolean.valueOf(true));
                }
                if (((Boolean)bs.getValue((Property)KitchenStove.LIT)).booleanValue()) {
                    BlockEntity blockEntity;
                    --this.cd;
                    if (!this.isInfinite) {
                        --this.process;
                        syncNeeded = true;
                    }
                    if (this.attachedChimney != null && (blockEntity = this.getLevel().getBlockEntity(this.attachedChimney)) instanceof ChimneyPotBlockEntity) {
                        ChimneyPotBlockEntity chimney = (ChimneyPotBlockEntity)blockEntity;
                        chimney.addAsh(this.speed);
                    }
                    if (this.cd <= 0) {
                        bs = (BlockState)bs.setValue((Property)KitchenStove.LIT, (Comparable)Boolean.valueOf(false));
                        flag = true;
                    }
                }
            }
            if (flag) {
                this.level.setBlockAndUpdate(this.getBlockPos(), bs);
            }
            if (syncNeeded) {
                this.syncData();
            }
        } else if (((Boolean)this.getBlockState().getValue((Property)KitchenStove.LIT)).booleanValue()) {
            double d0 = this.getBlockPos().getX();
            double d1 = this.getBlockPos().getY();
            double d2 = this.getBlockPos().getZ();
            RandomSource rand = this.getLevel().random;
            if (this.attachedChimney == null) {
                if (rand.nextDouble() < 0.25 * (double)this.speed) {
                    this.getLevel().addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + 0.5, d1 + 1.0, d2 + 0.5, rand.nextDouble() * 0.5 - 0.25, rand.nextDouble() * 0.125, rand.nextDouble() * 0.5 - 0.25);
                }
            } else if (rand.nextDouble() < 0.25 * (double)this.speed) {
                double motY = -0.3;
                double delY = 0.5;
                if (!this.getLevel().getBlockState(this.attachedChimney).is(CPTags.Blocks.CHIMNEY_POT)) {
                    motY = rand.nextDouble() * 0.25;
                    delY = 0.0;
                }
                this.getLevel().addParticle((ParticleOptions)CPParticles.SOOT.get(), (double)this.attachedChimney.getX() + 0.5, (double)this.attachedChimney.getY() + delY, (double)this.attachedChimney.getZ() + 0.5, rand.nextDouble() * 0.5 - 0.25, motY, rand.nextDouble() * 0.5 - 0.25);
            }
        }
    }

    @Override
    public int requestHeat() {
        if (this.process <= 0) {
            if (!this.consumeFuel()) {
                return 0;
            }
            if (!this.isInfinite) {
                --this.process;
            }
        }
        BlockState bs = this.getBlockState();
        this.cd = this.maxcd;
        if (!((Boolean)bs.getValue((Property)KitchenStove.LIT)).booleanValue()) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)bs.setValue((Property)KitchenStove.LIT, (Comparable)Boolean.valueOf(true)));
        }
        return this.speed;
    }

    @Override
    public boolean canEmitHeat() {
        return this.process > 0 || ((ItemStack)this.fuel.get(0)).getBurnTime(RecipeType.SMELTING) > 0;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Override
    public boolean setInfinity() {
        this.isInfinite = !this.isInfinite;
        return this.isInfinite;
    }
}

