/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.stove;

import com.teammoeg.caupona.blocks.CPRegisteredEntityBlock;
import com.teammoeg.caupona.blocks.stove.KitchenStoveBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;

public class KitchenStove
extends CPRegisteredEntityBlock<KitchenStoveBlockEntity> {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty ASH = BooleanProperty.create((String)"ash");
    public static final IntegerProperty FUELED = IntegerProperty.create((String)"fueled", (int)0, (int)3);
    static final VoxelShape shape = Shapes.or((VoxelShape)Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)14.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0))));

    public KitchenStove(BlockBehaviour.Properties blockProps, DeferredHolder<BlockEntityType<?>, BlockEntityType<KitchenStoveBlockEntity>> ste) {
        super(blockProps, ste);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos bp, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            double d0 = bp.getX();
            double d1 = bp.getY();
            double d2 = bp.getZ();
            if (rand.nextDouble() < 0.2) {
                worldIn.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + rand.nextDouble(), (double)(bp.getY() + 1), d2 + rand.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        KitchenStoveBlockEntity stove;
        ItemStack is;
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof KitchenStoveBlockEntity && !(is = (stove = (KitchenStoveBlockEntity)blockEntity).getItem(0)).isEmpty()) {
            CPRegisteredEntityBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)is);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING}).add(new Property[]{LIT}).add(new Property[]{FUELED}).add(new Property[]{ASH});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)ASH, (Comparable)Boolean.valueOf(false))).setValue((Property)FUELED, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            pEntity.hurt(pLevel.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(pLevel, pPos, pState, pEntity);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult p = super.useWithoutItem(state, worldIn, pos, player, hit);
        if (p.consumesAction()) {
            return p;
        }
        KitchenStoveBlockEntity blockEntity = (KitchenStoveBlockEntity)worldIn.getBlockEntity(pos);
        if (blockEntity != null && (player.getAbilities().instabuild || !blockEntity.isInfinite)) {
            if (!worldIn.isClientSide) {
                ((ServerPlayer)player).openMenu((MenuProvider)blockEntity, blockEntity.getBlockPos());
            }
            return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide());
        }
        return p;
    }
}

