/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.stove;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ChimneyPotBlockEntity
extends CPBaseBlockEntity {
    private int process;
    private int processMax;
    int countSoot;
    private int maxStore;

    public ChimneyPotBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.CHIMNEY_POT.get(), pWorldPosition, pBlockState);
        this.processMax = (Integer)CPConfig.SERVER.chimneyTicks.get();
        this.maxStore = (Integer)CPConfig.SERVER.chimneyStorage.get();
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        this.process = nbt.getInt("process");
        this.countSoot = nbt.getInt("soot");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        nbt.putInt("process", this.process);
        nbt.putInt("soot", this.countSoot);
    }

    public void addAsh(int val) {
        this.process += val;
        this.setChanged();
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && this.process >= this.processMax) {
            if (this.countSoot < this.maxStore) {
                ++this.countSoot;
                this.syncData();
            }
            this.process = 0;
            this.setChanged();
        }
    }
}

