/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.stove;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.blocks.CPHorizontalEntityBlock;
import com.teammoeg.caupona.blocks.stove.ChimneyPotBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ChimneyPotBlock
extends CPHorizontalEntityBlock<ChimneyPotBlockEntity> {
    static final VoxelShape shape = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public ChimneyPotBlock(BlockBehaviour.Properties p_54120_) {
        super(CPBlockEntityTypes.CHIMNEY_POT, p_54120_);
        CPBlocks.chimney.add((Block)this);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (stack.getItem() instanceof ShovelItem && (blockEntity = level.getBlockEntity(pos)) instanceof ChimneyPotBlockEntity) {
            ChimneyPotBlockEntity chimneyPot = (ChimneyPotBlockEntity)blockEntity;
            if (chimneyPot.countSoot > 0) {
                if (!level.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)CPItems.soot.get(), chimneyPot.countSoot));
                    chimneyPot.countSoot = 0;
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

