/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.pot;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.blocks.pot.StewPotContainer;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.data.recipes.AspicMeltingRecipe;
import com.teammoeg.caupona.data.recipes.BoilingRecipe;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.data.recipes.DissolveRecipe;
import com.teammoeg.caupona.data.recipes.DoliumRecipe;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.data.recipes.SpiceRecipe;
import com.teammoeg.caupona.data.recipes.StewCookingRecipe;
import com.teammoeg.caupona.data.recipes.StewPendingContext;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.IInfinitable;
import com.teammoeg.caupona.util.LazyTickWorker;
import com.teammoeg.caupona.util.SyncedFluidHandler;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;

public class StewPotBlockEntity
extends CPBaseBlockEntity
implements MenuProvider,
IInfinitable {
    private ItemStackHandler inv = new ItemStackHandler(this, 12){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 9) {
                return stack.getItem() == Items.POTION && !StreamSupport.stream(((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).getAllEffects().spliterator(), false).anyMatch(t -> t.getDuration() == 1) || StewCookingRecipe.isCookable(stack);
            }
            if (slot == 9) {
                Item i = stack.getItem();
                return i == Items.BOWL || Utils.getFluidType(stack) != Fluids.EMPTY || AspicMeltingRecipe.find(stack) != null;
            }
            if (slot == 11) {
                return SpiceRecipe.isValid(stack);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            if (slot < 9) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }
    };
    private FluidTank tank = new FluidTank(1250, StewCookingRecipe::isBoilable){

        protected void onContentsChanged() {
            StewPotBlockEntity.this.still.rewind();
        }
    };
    public int process;
    public int processMax;
    public LazyTickWorker still;
    public LazyTickWorker contain;
    public boolean working = false;
    public boolean operate = false;
    public short proctype = 0;
    public boolean rsstate = false;
    boolean isInfinite = false;
    public FluidStack output;
    public static final short NOP = 0;
    public static final short BOILING = 1;
    public static final short COOKING = 2;
    public static final short STIRING = 3;
    IFluidHandler handler = new SyncedFluidHandler(this, new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int t) {
            if (t == 0) {
                return StewPotBlockEntity.this.tank.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int t) {
            if (t == 0) {
                return StewPotBlockEntity.this.tank.getCapacity();
            }
            return 0;
        }

        public boolean isFluidValid(int t, FluidStack stack) {
            if (t == 0 && StewPotBlockEntity.this.canAddFluid()) {
                return StewPotBlockEntity.this.tank.isFluidValid(stack);
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (StewPotBlockEntity.this.canAddFluid() && !StewPotBlockEntity.this.isInfinite) {
                return StewPotBlockEntity.this.tank.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (StewPotBlockEntity.this.canAddFluid()) {
                if (StewPotBlockEntity.this.isInfinite) {
                    return action.simulate() ? resource : StewPotBlockEntity.this.tryAddSpice(resource);
                }
                return action.simulate() ? StewPotBlockEntity.this.tank.drain(resource, action) : StewPotBlockEntity.this.tryAddSpice(StewPotBlockEntity.this.tank.drain(resource, action));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (StewPotBlockEntity.this.canAddFluid()) {
                if (StewPotBlockEntity.this.isInfinite) {
                    return action.simulate() ? StewPotBlockEntity.this.tank.getFluid().copyWithAmount(maxDrain) : StewPotBlockEntity.this.tryAddSpice(StewPotBlockEntity.this.tank.getFluid().copyWithAmount(maxDrain));
                }
                return action.simulate() ? StewPotBlockEntity.this.tank.drain(maxDrain, action) : StewPotBlockEntity.this.tryAddSpice(StewPotBlockEntity.this.tank.drain(maxDrain, action));
            }
            return FluidStack.EMPTY;
        }
    });
    public IItemHandler bowl = new IItemHandler(){

        public int getSlots() {
            return StewPotBlockEntity.this.inv.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return StewPotBlockEntity.this.inv.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot < 9 || slot == 10) {
                return stack;
            }
            return StewPotBlockEntity.this.inv.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 9 || slot == 11) {
                return ItemStack.EMPTY;
            }
            if (slot < 9 && StewPotBlockEntity.this.inv.isItemValid(slot, StewPotBlockEntity.this.inv.getStackInSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return StewPotBlockEntity.this.inv.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return StewPotBlockEntity.this.inv.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot < 9 || slot == 10) {
                return false;
            }
            return StewPotBlockEntity.this.inv.isItemValid(slot, stack);
        }
    };
    RangedWrapper ingredient = new RangedWrapper(this, (IItemHandlerModifiable)this.inv, 0, 10){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }
    };

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public StewPotBlockEntity(BlockPos p, BlockState s) {
        super((BlockEntityType)CPBlockEntityTypes.STEW_POT.get(), p, s);
        this.still = new LazyTickWorker((Integer)CPConfig.COMMON.staticTime.get(), () -> {
            DoliumRecipe recipe;
            if (this.inv.getStackInSlot(10).isEmpty() && (recipe = DoliumRecipe.testPot(this.getTank().getFluid())) != null) {
                ItemStack out = recipe.handle(this.getTank().getFluid());
                this.inv.setStackInSlot(10, out);
            }
            return true;
        });
        this.contain = new LazyTickWorker((Integer)CPConfig.SERVER.containerTick.get(), () -> {
            if (this.isInfinite) {
                FluidStack fs = this.tank.getFluid().copyWithAmount(this.tank.getFluidAmount());
                if (this.canAddFluid()) {
                    this.tryContianFluid();
                }
                this.tank.setFluid(fs);
            } else if (this.canAddFluid() && this.tryContianFluid()) {
                return true;
            }
            return false;
        });
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void resetResult() {
        this.output = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tick() {
        boolean syncNeeded = false;
        if (this.level.isClientSide) return;
        this.working = false;
        if (this.processMax > 0) {
            this.still.rewind();
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.below());
            if (!(blockEntity instanceof IStove)) return;
            IStove stove = (IStove)blockEntity;
            int rh = stove.requestHeat();
            if (!this.isInfinite) {
                this.process += rh;
                if (rh > 0) {
                    syncNeeded = true;
                }
            }
            if (rh > 0) {
                this.working = true;
            }
            if (this.process >= this.processMax) {
                this.process = 0;
                this.processMax = 0;
                this.doWork();
                syncNeeded = true;
            }
        } else {
            if (!this.tank.isEmpty() && !this.isInfinite) {
                syncNeeded |= this.still.tick();
            }
            if (!this.isInfinite && this.proctype <= 1) {
                this.prepareWork();
                if (this.proctype != 0) {
                    syncNeeded = true;
                }
            }
            syncNeeded |= this.contain.tick();
        }
        if (!syncNeeded) return;
        this.syncData();
    }

    private FluidStack tryAddSpice(FluidStack fs) {
        ItemStack ospi;
        SpiceRecipe spice = null;
        ItemStack spi = ospi = this.inv.getStackInSlot(11);
        if (fs.getAmount() % 250 == 0 && fs.getFluid() instanceof SoupFluid) {
            spice = SpiceRecipe.find(spi);
        }
        StewInfo si = null;
        if (this.getBlockState().is((Block)CPBlocks.STEW_POT_LEAD.get())) {
            if (spice == null) {
                si = Utils.getOrCreateInfo(fs);
                if (si.getDensity() > 1.5f) {
                    spi = CPItems.getSapa();
                    spice = SpiceRecipe.find(spi);
                }
            } else if (spice.canReactLead) {
                spi = CPItems.getSapa();
                spice = SpiceRecipe.find(spi);
            }
        }
        if (spice != null) {
            if (si == null) {
                si = Utils.getOrCreateInfo(fs);
            }
            if (!si.canAddSpice()) {
                return fs;
            }
            if (!this.isInfinite) {
                int consume = fs.getAmount() / 250;
                if (SpiceRecipe.getMaxUse(spi) < consume) {
                    return fs;
                }
                this.inv.setStackInSlot(11, SpiceRecipe.handle(ospi, consume));
            }
            si.addSpice(spice.effect, spi);
            Utils.setInfo((MutableDataComponentHolder)fs, si);
        }
        return fs;
    }

    private boolean tryContianFluid() {
        ItemStack is = this.inv.getStackInSlot(9);
        if (!is.isEmpty() && this.inv.getStackInSlot(10).isEmpty()) {
            AspicMeltingRecipe amr;
            RecipeHolder<BowlContainingRecipe> recipe;
            if (is.getItem() == Items.BOWL && this.tank.getFluidAmount() >= 250 && (recipe = BowlContainingRecipe.recipes.get(this.tank.getFluid().getFluid())) != null) {
                is.shrink(1);
                this.inv.setStackInSlot(10, ((BowlContainingRecipe)recipe.value()).handle(this.tryAddSpice(this.tank.drain(250, IFluidHandler.FluidAction.EXECUTE))));
                this.still.rewind();
                return true;
            }
            FluidStack out = Utils.extractFluid(is);
            if (!out.isEmpty()) {
                if (this.tryAddFluid(out)) {
                    ItemStack ret = is.getCraftingRemainingItem();
                    is.shrink(1);
                    this.still.rewind();
                    this.inv.setStackInSlot(10, ret);
                    return true;
                }
                return false;
            }
            if (!this.isInfinite && (amr = AspicMeltingRecipe.find(is)) != null) {
                int remainSpace = this.tank.getCapacity() - this.tank.getFluidAmount();
                int produce = Math.min(remainSpace / amr.amount, is.getCount());
                FluidStack fs = amr.handle(is);
                fs.setAmount(fs.getAmount() * produce);
                if (this.tryAddFluid(fs, amr.time, false)) {
                    ItemStack ret = is.getCraftingRemainingItem();
                    ret.setCount(produce);
                    is.shrink(produce);
                    this.still.rewind();
                    this.inv.setStackInSlot(10, ret);
                    return true;
                }
                return false;
            }
            FluidActionResult far = FluidUtil.tryFillContainer((ItemStack)is, (IFluidHandler)this.tank, (int)1250, null, (boolean)true);
            if (far.isSuccess()) {
                is.shrink(1);
                if (far.getResult() != null) {
                    this.still.rewind();
                    this.inv.setStackInSlot(10, far.getResult());
                }
            }
        }
        return false;
    }

    public boolean canAddFluid() {
        return this.proctype == 0;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider provider) {
        this.process = nbt.getInt("process");
        this.processMax = nbt.getInt("processMax");
        this.proctype = nbt.getShort("worktype");
        this.rsstate = nbt.getBoolean("rsstate");
        if (this.inv.getSlots() < 12) {
            this.inv.setSize(12);
        }
        if (isClient) {
            this.working = nbt.getBoolean("working");
        }
        this.tank.readFromNBT(provider, nbt);
        if (nbt.contains("output")) {
            this.output = FluidStack.parse((HolderLookup.Provider)provider, (Tag)nbt.get("output")).orElse(null);
        }
        this.isInfinite = nbt.getBoolean("inf");
        if (!isClient) {
            this.inv.deserializeNBT(provider, nbt.getCompound("inv"));
            this.still.read(nbt, "nowork");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider provider) {
        nbt.putInt("process", this.process);
        nbt.putInt("processMax", this.processMax);
        nbt.putShort("worktype", this.proctype);
        nbt.putBoolean("rsstate", this.rsstate);
        if (isClient) {
            nbt.putBoolean("working", this.working);
        }
        this.tank.writeToNBT(provider, nbt);
        if (this.output != null) {
            nbt.put("output", this.output.save(provider));
        }
        nbt.putBoolean("inf", this.isInfinite);
        if (!isClient) {
            nbt.put("inv", (Tag)this.inv.serializeNBT(provider));
            this.still.write(nbt, "nowork");
        }
    }

    private void prepareWork() {
        if (this.rsstate && this.proctype == 0 && !this.operate && this.level.hasNeighborSignal(this.worldPosition)) {
            this.operate = true;
        }
        if (this.operate && this.proctype == 0) {
            IStove stove;
            this.operate = false;
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.below());
            if (!(blockEntity instanceof IStove) || !(stove = (IStove)blockEntity).canEmitHeat()) {
                return;
            }
            if (this.doBoil()) {
                this.proctype = 1;
            } else if (this.makeSoup()) {
                this.proctype = (short)2;
            }
        } else if (this.proctype == 1) {
            if (this.makeSoup()) {
                this.proctype = (short)2;
            } else {
                this.proctype = 0;
                this.syncData();
            }
        }
    }

    private void doWork() {
        if (this.output != null) {
            this.tank.setFluid(this.output);
            this.output = null;
            if (this.proctype == 1) {
                boolean hasItem = false;
                for (int i = 0; i < 9; ++i) {
                    ItemStack is = this.inv.getStackInSlot(i);
                    if (is.isEmpty()) continue;
                    hasItem = true;
                    break;
                }
                if (!hasItem) {
                    this.proctype = 0;
                }
            } else {
                this.proctype = 0;
            }
        } else {
            this.proctype = 0;
        }
    }

    private boolean doBoil() {
        RecipeHolder<BoilingRecipe> recipeh = BoilingRecipe.recipes.get(this.tank.getFluid().getFluid());
        if (recipeh == null) {
            return false;
        }
        BoilingRecipe recipe = (BoilingRecipe)recipeh.value();
        this.output = recipe.handle(this.tank.getFluid());
        this.processMax = (int)((float)recipe.time * ((float)this.tank.getFluidAmount() / 250.0f));
        this.process = 0;
        return true;
    }

    private void adjustParts(int count) {
        float oparts = (float)this.tank.getFluidAmount() / 250.0f;
        int parts = (int)(oparts + (float)count);
        StewInfo currentInfo = Utils.getOrCreateInfo(this.tank.getFluid()).copy();
        currentInfo.adjustParts(oparts, parts);
        this.tank.getFluid().setAmount(parts * 250);
        Utils.setInfo((MutableDataComponentHolder)this.tank.getFluid(), currentInfo);
    }

    private boolean makeSoup() {
        ItemStack is;
        if (this.tank.getFluidAmount() <= 250) {
            return false;
        }
        StewInfo currentInfo = Utils.getOrCreateInfo(this.tank.getFluid());
        if (currentInfo.stacks.size() > 27) {
            return false;
        }
        int oparts = this.tank.getFluidAmount() / 250;
        int parts = oparts - 1;
        int itms = 0;
        ArrayList<MobEffectInstance> cr = new ArrayList<MobEffectInstance>(currentInfo.effects);
        for (int i = 0; i < 9; ++i) {
            ItemStack is2 = this.inv.getStackInSlot(i);
            if (is2.isEmpty()) continue;
            if (is2.getItem() == Items.POTION) {
                block1: for (MobEffectInstance n : ((PotionContents)is2.get(DataComponents.POTION_CONTENTS)).getAllEffects()) {
                    for (MobEffectInstance eff : cr) {
                        if (!StewInfo.isEffectEquals(eff, n)) continue;
                        continue block1;
                    }
                    cr.add(n);
                }
                continue;
            }
            if (StewCookingRecipe.isCookable(is2)) {
                ++itms;
                continue;
            }
            return false;
        }
        if ((float)itms / (float)parts + currentInfo.getDensity() * (float)oparts / (float)parts > 3.0f || cr.size() > 3) {
            return false;
        }
        this.process = 0;
        this.adjustParts(-1);
        currentInfo = Utils.getOrCreateInfo(this.tank.getFluid());
        boolean hasItem = false;
        NonNullList interninv = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 9; ++i) {
            ItemStack is3 = this.inv.getStackInSlot(i);
            if (is3.isEmpty()) continue;
            if (is3.getItem() == Items.POTION) {
                for (MobEffectInstance eff : ((PotionContents)is3.get(DataComponents.POTION_CONTENTS)).getAllEffects()) {
                    currentInfo.addEffect(eff, parts);
                }
                this.inv.setStackInSlot(i, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            } else {
                for (int j = 0; j < 9; ++j) {
                    ItemStack ois = (ItemStack)interninv.get(j);
                    if (ois.isEmpty()) {
                        interninv.set(j, (Object)is3.copy());
                        break;
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)ois, (ItemStack)is3)) continue;
                    ois.setCount(ois.getCount() + is3.getCount());
                    break;
                }
                this.inv.setStackInSlot(i, is3.getCraftingRemainingItem());
            }
            hasItem = true;
        }
        if (!hasItem) {
            currentInfo.completeEffects();
            this.processMax = Math.max((Integer)CPConfig.SERVER.potCookTimeBase.get(), this.decideSoup());
            return true;
        }
        int tpt = (Integer)CPConfig.SERVER.potMixTimeBase.get();
        block6: for (int i = 0; i < 9 && !(is = (ItemStack)interninv.get(i)).isEmpty(); ++i) {
            currentInfo.addItem(is, parts);
            for (RecipeHolder recipeHolder : DissolveRecipe.recipes) {
                if (!((DissolveRecipe)recipeHolder.value()).item.test(is)) continue;
                tpt += ((DissolveRecipe)recipeHolder.value()).time;
                continue block6;
            }
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(is.getItem());
            if (fvr == null) continue;
            tpt += fvr.processtimes.getOrDefault(is.getItem(), 0).intValue();
        }
        currentInfo.completeAll();
        tpt = Math.max((Integer)CPConfig.SERVER.potCookTimeBase.get(), tpt);
        interninv.clear();
        this.output = this.tank.getFluid().copy();
        Utils.setInfo((MutableDataComponentHolder)this.output, currentInfo);
        this.decideSoup();
        this.processMax = Math.max(this.decideSoup(), tpt);
        return true;
    }

    private int decideSoup() {
        if (this.output == null) {
            this.output = this.tank.getFluid();
        }
        Fluid become = this.output.getFluid();
        StewInfo currentInfo = Utils.getOrCreateInfo(this.output);
        StewPendingContext ctx = new StewPendingContext(currentInfo, become);
        Fluid nextbase = become;
        if (ctx.getItems().isEmpty()) {
            return 0;
        }
        for (RecipeHolder<StewCookingRecipe> cr : StewCookingRecipe.sorted) {
            int mt = ((StewCookingRecipe)cr.value()).matches(ctx);
            if (mt == 0) continue;
            nextbase = mt == 2 ? become : currentInfo.base;
            become = ((StewCookingRecipe)cr.value()).output;
            FluidStack preout = new FluidStack(become, this.output.getAmount());
            if (!((StewCookingRecipe)cr.value()).removeNBT) {
                currentInfo.base = nextbase;
                preout.applyComponents(this.output.getComponentsPatch());
                currentInfo.recalculateHAS();
                Utils.setInfo((MutableDataComponentHolder)preout, currentInfo);
            }
            this.output = preout;
            return ((StewCookingRecipe)cr.value()).time;
        }
        return 0;
    }

    public boolean canAddFluid(FluidStack fs) {
        IStove stove;
        if (this.isInfinite) {
            return false;
        }
        int tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
        if (tryfill > 0) {
            return tryfill == fs.getAmount();
        }
        if (this.tank.getCapacity() - this.tank.getFluidAmount() < fs.getAmount()) {
            return false;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.below());
        if (!(blockEntity instanceof IStove) || !(stove = (IStove)blockEntity).canEmitHeat()) {
            return false;
        }
        StewInfo n = Utils.getOrCreateInfo(fs);
        StewInfo currentInfo = Utils.getOrCreateInfo(this.tank.getFluid());
        if (currentInfo.base != n.base && n.base != this.tank.getFluid().getFluid()) {
            RecipeHolder<BoilingRecipe> bnx = BoilingRecipe.recipes.get(fs.getFluid());
            if (bnx == null) {
                return false;
            }
            if (currentInfo.base != ((BoilingRecipe)bnx.value()).after) {
                return false;
            }
        }
        return currentInfo.canMerge(n, (float)this.tank.getFluidAmount() / 250.0f, (float)fs.getAmount() / 250.0f);
    }

    public boolean tryAddFluid(FluidStack fs) {
        return this.tryAddFluid(fs, (Integer)CPConfig.SERVER.potMixTimeBase.get(), true);
    }

    public boolean tryAddFluid(FluidStack fs, int extraTime, boolean canIgnoreHeat) {
        IStove stove;
        int tryfill;
        if (this.isInfinite) {
            return false;
        }
        if (canIgnoreHeat) {
            tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
            if (tryfill > 0) {
                if (tryfill == fs.getAmount()) {
                    this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                    this.still.rewind();
                    return true;
                }
                return false;
            }
        } else if (this.tank.isEmpty() && (tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            if (tryfill == fs.getAmount()) {
                this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                this.proctype = (short)3;
                this.process = 0;
                this.processMax = extraTime;
                this.resetResult();
                this.still.rewind();
                return true;
            }
            return false;
        }
        if (this.tank.getCapacity() - this.tank.getFluidAmount() < fs.getAmount()) {
            return false;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.below());
        if (!(blockEntity instanceof IStove) || !(stove = (IStove)blockEntity).canEmitHeat()) {
            return false;
        }
        StewInfo n = Utils.getOrCreateInfo(fs);
        int pm = 0;
        StewInfo currentInfo = Utils.getOrCreateInfo(this.tank.getFluid());
        if (currentInfo.base != n.base && currentInfo.base != fs.getFluid() && n.base != this.tank.getFluid().getFluid()) {
            RecipeHolder<BoilingRecipe> bnx = BoilingRecipe.recipes.get(fs.getFluid());
            if (bnx == null) {
                return false;
            }
            if (currentInfo.base != ((BoilingRecipe)bnx.value()).after) {
                return false;
            }
            fs = ((BoilingRecipe)bnx.value()).handle(fs);
            pm = (int)((float)((BoilingRecipe)bnx.value()).time * ((float)fs.getAmount() / 250.0f));
        }
        if (currentInfo.merge(n, (float)this.tank.getFluidAmount() / 250.0f, (float)fs.getAmount() / 250.0f)) {
            this.adjustParts(fs.getAmount() / 250);
            int num = Math.max(this.decideSoup(), extraTime);
            this.proctype = (short)3;
            this.process = 0;
            this.processMax = Math.max(pm, num);
            this.still.rewind();
            return true;
        }
        return false;
    }

    public AbstractContainerMenu createMenu(int p1, Inventory p2, Player p3) {
        return new StewPotContainer(p1, p2, this);
    }

    public Component getDisplayName() {
        return Utils.translate("container.caupona.stewpot.title");
    }

    @Override
    public void handleMessage(short type, int data) {
        if (type == 0 && this.proctype == 0) {
            this.operate = true;
        }
        if (type == 1) {
            if (data == 1) {
                this.rsstate = false;
            } else if (data == 2) {
                this.rsstate = true;
            }
        }
        this.syncData();
    }

    @Override
    public Object getCapability(BlockCapability<?, Direction> cap, Direction side) {
        if (cap == Capabilities.ItemHandler.BLOCK) {
            if (side == Direction.UP) {
                return this.ingredient;
            }
            return this.bowl;
        }
        if (cap == Capabilities.FluidHandler.BLOCK) {
            return this.handler;
        }
        return null;
    }

    @Override
    public boolean setInfinity() {
        this.isInfinite = !this.isInfinite;
        return this.isInfinite;
    }
}

