/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.pot;

import com.teammoeg.caupona.blocks.CPRegisteredEntityBlock;
import com.teammoeg.caupona.blocks.pot.StewPotBlockEntity;
import com.teammoeg.caupona.client.CPParticles;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StewPot
extends CPRegisteredEntityBlock<StewPotBlockEntity>
implements LiquidBlockContainer {
    public static final EnumProperty<Direction.Axis> FACING = BlockStateProperties.HORIZONTAL_AXIS;
    static final VoxelShape shape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);

    public StewPot(BlockBehaviour.Properties blockProps, DeferredHolder<BlockEntityType<?>, BlockEntityType<StewPotBlockEntity>> ste) {
        super(blockProps, ste);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public ItemInteractionResult useItemOn(ItemStack held, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemInteractionResult p = super.useItemOn(held, state, worldIn, pos, player, handIn, hit);
        if (p.consumesAction()) {
            return p;
        }
        StewPotBlockEntity blockEntity = (StewPotBlockEntity)worldIn.getBlockEntity(pos);
        if (blockEntity.canAddFluid()) {
            if (held.isEmpty() && player.isShiftKeyDown()) {
                blockEntity.getTank().setFluid(FluidStack.EMPTY);
                return ItemInteractionResult.SUCCESS;
            }
            FluidStack out = Utils.extractFluid(held);
            if (!out.isEmpty()) {
                if (blockEntity.tryAddFluid(out)) {
                    ItemStack ret = held.getCraftingRemainingItem();
                    held.shrink(1);
                    if (!player.addItem(ret)) {
                        player.drop(ret, false);
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
            }
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)blockEntity.getTank())) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return p;
    }

    public boolean canPlaceLiquid(Player ps, BlockGetter w, BlockPos p, BlockState s, Fluid f) {
        StewPotBlockEntity blockEntity = (StewPotBlockEntity)w.getBlockEntity(p);
        return blockEntity.canAddFluid(new FluidStack(f, 1000));
    }

    public boolean placeLiquid(LevelAccessor w, BlockPos p, BlockState s, FluidState f) {
        StewPotBlockEntity blockEntity = (StewPotBlockEntity)w.getBlockEntity(p);
        return blockEntity.tryAddFluid(new FluidStack(f.getType(), 1000));
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof StewPotBlockEntity) {
            StewPotBlockEntity pot = (StewPotBlockEntity)blockEntity;
            if (pot.proctype == 2 && pot.working) {
                int count = 2;
                while (--count != 0) {
                    worldIn.addParticle((ParticleOptions)CPParticles.STEAM.get(), (double)((float)pos.getX() + rand.nextFloat()), (double)(pos.getY() + 1), (double)((float)pos.getZ() + rand.nextFloat()), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof StewPotBlockEntity) {
            StewPotBlockEntity pot = (StewPotBlockEntity)blockEntity;
            if (state.getBlock() != newState.getBlock()) {
                ItemStack is;
                if (pot.proctype != 2) {
                    for (int i = 0; i < 9; ++i) {
                        is = pot.getInv().getStackInSlot(i);
                        if (is.isEmpty()) continue;
                        CPRegisteredEntityBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)is);
                    }
                }
                for (int i = 9; i < 12; ++i) {
                    is = pot.getInv().getStackInSlot(i);
                    if (is.isEmpty()) continue;
                    CPRegisteredEntityBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)is);
                }
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getAxis());
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        StewPotBlockEntity blockEntity = (StewPotBlockEntity)pLevel.getBlockEntity(pPos);
        if (blockEntity.proctype == 0) {
            int ret = 1;
            for (int i = 0; i < 9; ++i) {
                ItemStack is = blockEntity.getInv().getStackInSlot(i);
                if (is.isEmpty()) continue;
                ++ret;
            }
            return ret += blockEntity.getTank().getFluidAmount() / 250;
        }
        return 0;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        InteractionResult p = super.useWithoutItem(state, level, pos, player, hitResult);
        if (p.consumesAction()) {
            return p;
        }
        StewPotBlockEntity blockEntity = (StewPotBlockEntity)level.getBlockEntity(pos);
        if (!(blockEntity == null || level.isClientSide || !player.getAbilities().instabuild && blockEntity.isInfinite)) {
            ((ServerPlayer)player).openMenu((MenuProvider)blockEntity, blockEntity.getBlockPos());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

