/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.plants;

import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.plants.FruitBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;

public class SnailBlock
extends FruitBlock {
    public static final BooleanProperty EATEN_FRUIT = BooleanProperty.create((String)"plump");
    private static final BlockPos[] NEIGH = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1)};
    private static final int[] ORDER = new int[]{0, -1, 1};

    public SnailBlock(BlockBehaviour.Properties p_52247_) {
        super(p_52247_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)EATEN_FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.above()).is(CPTags.Blocks.SNAIL_GROWABLE_ON);
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return false;
    }

    @Override
    public int getMaxAge() {
        return 4;
    }

    public int getMaxAge(BlockState state) {
        return (Boolean)state.getValue((Property)EATEN_FRUIT) != false ? 4 : 3;
    }

    public BlockState getStateForAge(BlockState orig, int pAge) {
        return (BlockState)orig.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(pAge));
    }

    @Override
    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos growable;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        int i = this.getAge(pState);
        if (i < this.getMaxAge(pState)) {
            int eat;
            if (CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt(3) == 0 ? 1 : 0) != 0) && (eat = this.eatFirstEdible(pPos, pLevel)) > 0) {
                if (eat == 2) {
                    pState = (BlockState)pState.setValue((Property)EATEN_FRUIT, (Comparable)Boolean.valueOf(true));
                }
                pLevel.setBlock(pPos, this.getStateForAge(pState, i + 1), 2);
                CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        } else if (pRandom.nextInt(3) == 0 && (growable = this.findGrowableBlock(pPos, pLevel)) != null) {
            BlockState state = pLevel.getBlockState(growable);
            int eat = this.eatFirstEdible(pPos, pLevel);
            if (eat > 0) {
                if (state.is(CPTags.Blocks.SNAIL_FOOD) || eat == 2) {
                    this.trySpread(growable, pLevel);
                } else if (pRandom.nextInt(2) == 0) {
                    this.trySpread(growable, pLevel);
                }
            }
        }
    }

    public BlockPos findGrowableBlock(BlockPos pos, ServerLevel level) {
        for (BlockPos bp : NEIGH) {
            BlockState down;
            BlockPos cur = pos.offset((Vec3i)bp);
            if (!this.canSurvive(this.defaultBlockState(), (LevelReader)level, cur) || !(down = level.getBlockState(cur)).is(Blocks.AIR) && !down.canBeReplaced() && !down.is(CPTags.Blocks.SNAIL_FOOD)) continue;
            return cur;
        }
        return null;
    }

    public void trySpread(BlockPos pos, ServerLevel level) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 0);
        if (level.getBlockState(pos.above()).is(Blocks.AIR)) {
            level.setBlock(pos.above(), ((Block)CPBlocks.SNAIL_MUCUS.get()).defaultBlockState(), 2);
        }
        level.setBlock(pos, this.defaultBlockState(), 2);
    }

    public int eatFirstEdible(BlockPos pos, ServerLevel level) {
        int res = this.eatBlock(pos.above(), level, true);
        if (res > 0) {
            return res;
        }
        for (int x : ORDER) {
            for (int z : ORDER) {
                res = this.eatBlock(pos.offset(x, 0, z), level, false);
                if (res <= 0) continue;
                return res;
            }
        }
        for (int y = 2; y > 0; --y) {
            for (int x : ORDER) {
                for (int z : ORDER) {
                    res = this.eatBlock(pos.offset(x, y, z), level, y == 1 && x == 0 && z == 0);
                    if (res <= 0) continue;
                    return res;
                }
            }
        }
        return 0;
    }

    public int eatBlock(BlockPos pos, ServerLevel level, boolean toMucus) {
        BlockState bs = level.getBlockState(pos);
        if (bs.is(CPTags.Blocks.SNAIL_FOOD)) {
            Block blk = bs.getBlock();
            boolean isplump = bs.is(CPTags.Blocks.SNAIL_PLUMP_FOOD);
            if (blk instanceof CropBlock) {
                CropBlock cb = (CropBlock)blk;
                if (cb.isMaxAge(bs)) {
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                    return isplump ? 2 : 1;
                }
            } else {
                if (toMucus || level.getBlockState(pos.below()).is((Block)CPBlocks.SNAIL.get())) {
                    level.setBlock(pos, ((Block)CPBlocks.SNAIL_MUCUS.get()).defaultBlockState(), 2);
                    return isplump ? 2 : 1;
                }
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                return isplump ? 2 : 1;
            }
        }
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE, EATEN_FRUIT});
    }
}

