/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.plants;

import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.plants.FruitBlock;
import com.teammoeg.caupona.blocks.plants.SnailBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;

public class SnailBaitBlock
extends FruitBlock {
    public SnailBaitBlock(BlockBehaviour.Properties p_52247_) {
        super(p_52247_);
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.above()).is(CPTags.Blocks.SNAIL_GROWABLE_ON);
    }

    @Override
    public int getMaxAge() {
        return 7;
    }

    @Override
    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        int i = this.getAge(pState);
        if (i < this.getMaxAge()) {
            if (CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt(17) == 0 ? 1 : 0) != 0)) {
                pLevel.setBlock(pPos, this.getStateForAge(i + 1), 2);
                CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        } else {
            pLevel.setBlock(pPos, ((SnailBlock)((Object)CPBlocks.SNAIL.get())).getStateForAge(1), 2);
        }
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return false;
    }
}

