/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.plants;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SilphiumBlock
extends DoublePlantBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public SilphiumBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return true;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return (double)pRandom.nextFloat() < 0.1;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int dy = pState.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? 0 : 1;
        for (int i = 0; i < 3; ++i) {
            int dx = (pRandom.nextBoolean() ? 1 : -1) * pRandom.nextInt(3);
            int dz = (pRandom.nextBoolean() ? 1 : -1) * pRandom.nextInt(3);
            if (dx == 0 && dz == 0) {
                ++i;
                continue;
            }
            for (int j = 0; j < 3; ++j) {
                BlockPos pendPos = pPos.offset(dx, dy - j, dz);
                BlockState b0 = pLevel.getBlockState(pendPos);
                BlockState b1 = pLevel.getBlockState(pendPos.below());
                BlockState b2 = pLevel.getBlockState(pendPos.above());
                if (!b0.isAir() || !b2.isAir() || !b1.is(Blocks.GRASS_BLOCK)) continue;
                pLevel.setBlockAndUpdate(pendPos, this.defaultBlockState());
                pLevel.setBlockAndUpdate(pendPos.above(), (BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER));
                return;
            }
        }
    }
}

