/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.plants;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FruitsLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    DeferredHolder<Block, Block> fruit;

    public FruitsLeavesBlock(BlockBehaviour.Properties p_54422_, DeferredHolder<Block, Block> fruit2) {
        super(p_54422_);
        this.fruit = fruit2;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!((Boolean)pState.getValue((Property)PERSISTENT)).booleanValue()) {
            if ((Integer)pState.getValue((Property)DISTANCE) == 7) {
                FruitsLeavesBlock.dropResources((BlockState)pState, (Level)pLevel, (BlockPos)pPos);
                pLevel.removeBlock(pPos, false);
            } else {
                BlockPos below = pPos.below();
                if (pRandom.nextInt(51) == 0 && pLevel.getRawBrightness(below, 0) >= 9 && pLevel.getBlockState(below).isAir() && this.shouldPlaceFruit((Level)pLevel, below)) {
                    pLevel.setBlockAndUpdate(below, ((Block)this.fruit.get()).defaultBlockState());
                }
            }
        }
    }

    public boolean shouldPlaceFruit(Level pLevel, BlockPos pPos) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return false;
        }
        int cnt = 0;
        AABB aabb = new AABB((double)(pPos.getX() - 1), (double)pPos.getY(), (double)(pPos.getZ() - 1), (double)(pPos.getX() + 1), (double)pPos.getY(), (double)(pPos.getZ() + 1));
        Iterator it = pLevel.getBlockStates(aabb).iterator();
        while (it.hasNext()) {
            if (((BlockState)it.next()).getBlock() == this.fruit.get()) {
                ++cnt;
            }
            if (cnt < 2) continue;
            return false;
        }
        return true;
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Boolean)pState.getValue((Property)PERSISTENT) == false;
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return (Boolean)pState.getValue((Property)PERSISTENT) == false && (Integer)pState.getValue((Property)DISTANCE) != 7;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return pRandom.nextInt(4) == 0;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        if (pLevel.getBlockState(pPos.below()).isAir()) {
            pLevel.setBlockAndUpdate(pPos.below(), ((Block)this.fruit.get()).defaultBlockState());
        }
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }
}

